/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.util.Log;
import androidx.test.espresso.remote.FieldDescriptor;
import androidx.test.espresso.remote.MethodInvocation;
import androidx.test.espresso.remote.RemoteDescriptor-IA;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.remote.internal.deps.guava.base.Joiner;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.remote.internal.deps.guava.collect.Lists;
import androidx.test.espresso.remote.internal.deps.protobuf.Parser;
import java.util.List;
import java.util.Locale;

public final class RemoteDescriptor {
    private static final String TAG = "RemoteDescriptor";
    private final Class<?> instanceType;
    private final List<FieldDescriptor> instanceFieldDescriptorList;
    private final Class<?> remoteType;
    private final List<Class<?>> remoteConstrTypes;
    private final Class<?> protoType;
    private final Class<?> protoBuilderType;
    private final Parser<?> protoParser;

    public int hashCode() {
        return (((this.instanceType.hashCode() * 31 + this.remoteType.hashCode()) * 31 + this.protoType.hashCode()) * 31 + this.protoBuilderType.hashCode()) * 31 + this.protoParser.hashCode();
    }

    public Parser<?> getProtoParser() {
        return this.protoParser;
    }

    public Class<?> getInstanceType() {
        return this.instanceType;
    }

    public Class<?> getProtoBuilderClass() {
        return this.protoBuilderType;
    }

    public Class<?> getProtoType() {
        return this.protoType;
    }

    public Class<?> getRemoteType() {
        return this.remoteType;
    }

    public String getInstanceTypeName() {
        return this.instanceType.getName();
    }

    public List<FieldDescriptor> getInstanceFieldDescriptorList() {
        return this.instanceFieldDescriptorList;
    }

    /*
     * WARNING - void declaration
     */
    private RemoteDescriptor(Builder builder) {
        this(((Builder)var1_1).instanceType, ((Builder)var1_1).instanceFieldDescriptorList, ((Builder)var1_1).remoteType, ((Builder)var1_1).remoteConstrTypes, ((Builder)var1_1).protoType, ((Builder)var1_1).protoBuilderType, ((Builder)var1_1).protoParser);
        void var1_1;
    }

    /* synthetic */ RemoteDescriptor(Builder builder, RemoteDescriptor-IA remoteDescriptor-IA) {
        this(builder);
    }

    /*
     * WARNING - void declaration
     */
    private RemoteDescriptor(Class<?> instanceType, List<FieldDescriptor> instanceFieldDescriptorList, Class<?> remoteType, List<Class<?>> remoteConstrTypes, Class<?> protoType, Class<?> protoBuilderType, Parser<?> protoParser) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.instanceType = var1_1;
        this.instanceFieldDescriptorList = var2_2;
        this.remoteType = var3_3;
        this.remoteConstrTypes = var4_4;
        this.protoType = var5_5;
        this.protoBuilderType = var6_6;
        this.protoParser = var7_7;
    }

    public boolean equals(Object o) {
        RemoteDescriptor remoteDescriptor;
        if (this == remoteDescriptor) {
            return true;
        }
        if (remoteDescriptor == null || this.getClass() != remoteDescriptor.getClass()) {
            return false;
        }
        remoteDescriptor = remoteDescriptor;
        if (!this.instanceType.equals(remoteDescriptor.instanceType)) {
            return false;
        }
        if (!this.remoteType.equals(remoteDescriptor.remoteType)) {
            return false;
        }
        if (!this.protoType.equals(remoteDescriptor.protoType)) {
            return false;
        }
        if (!this.protoBuilderType.equals(remoteDescriptor.protoBuilderType)) {
            return false;
        }
        return this.protoParser.equals(remoteDescriptor.protoParser);
    }

    public Class<?>[] getRemoteConstrTypes() {
        List<Class<?>> list = this.remoteConstrTypes;
        int n = list.size();
        Class[] classArray = new Class[n];
        return this.remoteConstrTypes.toArray(classArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Builder {
        private static final String GENERIC_REMOTE_MESSAGE_CLS = "androidx.test.espresso.remote.GenericRemoteMessage";
        private Class<?> instanceType;
        private List<FieldDescriptor> instanceFieldDescriptorList = Lists.newArrayList();
        private Class<?> remoteType;
        private List<Class<?>> remoteConstrTypes;
        private Class<?> protoType;
        private Class<?> protoBuilderType;
        private Parser<?> protoParser;

        /*
         * WARNING - void declaration
         */
        public Builder setInstanceFieldDescriptors(FieldDescriptor ... fieldDescriptors) {
            void var1_1;
            this.instanceFieldDescriptorList = ImmutableList.copyOf((Object[])var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInstanceType(Class<?> instanceType) {
            void var1_1;
            this.instanceType = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProtoBuilderType(Class<?> protoBuilderType) {
            void var1_1;
            this.protoBuilderType = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProtoParser(Parser<?> protoParser) {
            void var1_1;
            this.protoParser = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setProtoType(Class<?> protoType) {
            void var1_1;
            this.protoType = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRemoteConstrTypes(Class<?> ... remoteConstrTypes) {
            void var1_1;
            this.remoteConstrTypes = ImmutableList.copyOf((Object[])var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRemoteType(Class<?> remoteType) {
            void var1_1;
            this.remoteType = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public RemoteDescriptor build() {
            boolean bl;
            Preconditions.checkNotNull(((Builder)this_).instanceType, "instanceType cannot be null! Use Builder.setInstanceType(Class<?> to set)");
            Preconditions.checkNotNull(((Builder)this_).instanceFieldDescriptorList, "instanceFieldDescriptorList cannot be null! Use Builder.setInstanceFieldDescriptors(FieldDescriptor...) to set");
            Preconditions.checkNotNull(((Builder)this_).remoteType, "remoteType cannot be null! Use Builder.setRemoteType(Class<?> to set");
            ((Builder)this_).instanceFieldDescriptorList = Builder.getFieldDescriptorsFromAnnotation(((Builder)this_).instanceType, ((Builder)this_).instanceFieldDescriptorList);
            if (((Builder)this_).remoteConstrTypes == null) {
                ((Builder)this_).remoteConstrTypes = ImmutableList.of(((Builder)this_).instanceType);
            }
            try {
                bl = ((Builder)this_).remoteType.isAssignableFrom(Class.forName(GENERIC_REMOTE_MESSAGE_CLS));
                if (bl) {
                    Class<Object> clazz = Object.class;
                    ((Builder)this_).remoteConstrTypes = ImmutableList.of(clazz);
                }
                bl = ((Builder)this_).protoType != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{GENERIC_REMOTE_MESSAGE_CLS};
                IllegalStateException illegalStateException = new IllegalStateException(String.format(locale, "Could not load class for name: %s", objectArray), classNotFoundException);
                throw illegalStateException;
            }
            Preconditions.checkArgument(bl, "protoType is a mandatory field!");
            if (((Builder)this_).protoBuilderType == null) {
                try {
                    ((Builder)this_).protoBuilderType = Class.forName(((Builder)this_).protoType.getName().concat("$Builder"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Object this_ = new IllegalArgumentException("Proto Builder type was not set. Attempt to load class with Class.forName() also failed!");
                    throw this_;
                }
            }
            if (((Builder)this_).protoParser != null) return new RemoteDescriptor((Builder)this_, null);
            MethodInvocation methodInvocation = new MethodInvocation(((Builder)this_).protoType, null, "parser", new Class[0]);
            ((Builder)this_).protoParser = (Parser)methodInvocation.invokeMethod(new Object[0]);
            bl = ((Builder)this_).protoParser != null;
            Preconditions.checkState(bl, "protoParser could not be inferred from proto type! Use Builder.setProtoParser(Parser<?>) to set");
            return new RemoteDescriptor((Builder)this_, null);
        }

        /*
         * WARNING - void declaration
         */
        private static List<FieldDescriptor> getFieldDescriptorsFromAnnotation(Class<?> instanceType, List<FieldDescriptor> originalFieldDescriptors) {
            void var1_1;
            List<FieldDescriptor> list = FieldDescriptor.getFieldDescriptorsFromAnnotation(instanceType, RemoteMsgField.class);
            if (!list.isEmpty()) {
                if (!var1_1.isEmpty()) {
                    Class<?> clazz;
                    Locale locale = Locale.ROOT;
                    Object[] objectArray = new Object[]{clazz, Joiner.on(",").join((Iterable)var1_1)};
                    Log.w((String)RemoteDescriptor.TAG, (String)String.format(locale, "RemoteMsgField field annotations found for type: %s. Ignoringfield descriptors: %s, registered with RemoteDescriptorRegistry", objectArray));
                }
                return list;
            }
            return var1_1;
        }
    }
}

