/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import androidx.test.espresso.remote.internal.deps.guava.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class ProtoUtils {
    /*
     * WARNING - void declaration
     */
    public static <T extends Enum> T checkedGetEnumForProto(int protoEnumIndex, Class<T> enumClass) {
        int n;
        Object object = (Enum[])enumClass.getEnumConstants();
        if (n < 0 || n >= ((Enum[])object).length) {
            void var1_1;
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{n, var1_1.getSimpleName()};
            object = new IllegalArgumentException(String.format(locale, "No such index: %d in enum class: %s", objectArray));
            throw object;
        }
        return (T)object[n];
    }

    public static String capitalizeFirstChar(String aString) {
        String string;
        if (aString == null || string.isEmpty()) {
            return string;
        }
        String string2 = string.substring(0, 1);
        Serializable serializable = Locale.ENGLISH;
        string2 = string2.toUpperCase((Locale)serializable);
        string = string.substring(1);
        serializable = new StringBuilder();
        return ((StringBuilder)serializable).append(string2).append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static Field getFieldRecursively(Class<?> clazz, String targetFieldName, NoSuchFieldException noSuchField) throws NoSuchFieldException {
        void var1_1;
        Class<?> clazz2;
        Field field;
        if (clazz == Object.class) {
            throw field;
        }
        try {
            field = clazz2.getDeclaredField((String)var1_1);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return ProtoUtils.getFieldRecursively(clazz2.getSuperclass(), (String)var1_1, noSuchFieldException);
        }
    }

    public static List<Field> getFilteredFieldList(Class<?> clazz, List<String> targetFieldNames) throws NoSuchFieldException {
        Iterator iterator;
        LinkedList linkedList = Lists.newLinkedList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz2;
            linkedList.add(ProtoUtils.getFieldRecursively(clazz2, (String)iterator.next(), null));
        }
        return linkedList;
    }

    private ProtoUtils() {
    }
}

