/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import androidx.test.espresso.proto.UiInteraction;
import androidx.test.espresso.remote.EspressoRemoteMessage;
import androidx.test.espresso.remote.InteractionResponse-IA;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class InteractionResponse
implements EspressoRemoteMessage.To<MessageLite> {
    private static final EspressoRemoteMessage.From<InteractionResponse, UiInteraction.InteractionResultProto> FROM;
    private final Status status;
    private final RemoteError remoteError;

    public RemoteError getRemoteError() {
        return this.remoteError;
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MessageLite toProto() {
        UiInteraction.InteractionResultProto.Builder builder = UiInteraction.InteractionResultProto.newBuilder();
        boolean bl = Status.Ok == this.status;
        UiInteraction.InteractionResultProto.Builder builder2 = builder.setOk(bl);
        if (this.remoteError != null) {
            builder2.setErrorMsg(UiInteraction.Error.newBuilder().setCode(this.remoteError.getCode()).setDescription(this.remoteError.getDescription()));
        }
        return builder2.build();
    }

    static {
        EspressoRemoteMessage.From<InteractionResponse, UiInteraction.InteractionResultProto> from;
        FROM = from = new EspressoRemoteMessage.From<InteractionResponse, UiInteraction.InteractionResultProto>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public InteractionResponse fromProto(UiInteraction.InteractionResultProto interactionResultProto) {
                Status status;
                Object object;
                Object object2;
                void var1_1;
                boolean bl = interactionResultProto.getOk();
                if (var1_1.hasErrorMsg()) {
                    object2 = var1_1.getErrorMsg();
                    int n = ((UiInteraction.Error)object2).getCode();
                    object2 = ((UiInteraction.Error)object2).getDescription();
                    object2 = RemoteError.isWellKnownError(n) ? (object = new RemoteError(n, RemoteError.getWellKnownFormattedErrorDescription(n, (String)object2))) : (object = new RemoteError(n, (String)object2));
                } else {
                    object2 = null;
                }
                object = new Builder();
                if (bl) {
                    status = Status.Ok;
                    return ((Builder)object).setStatus(status).setRemoteError((RemoteError)object2).build();
                }
                status = Status.Error;
                return ((Builder)object).setStatus(status).setRemoteError((RemoteError)object2).build();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private InteractionResponse(Builder builder) {
        this(((Builder)var1_1).status, ((Builder)var1_1).remoteError);
        void var1_1;
    }

    /* synthetic */ InteractionResponse(Builder builder, InteractionResponse-IA interactionResponse-IA) {
        this(builder);
    }

    /*
     * WARNING - void declaration
     */
    InteractionResponse(Status status, RemoteError remoteError) {
        void var2_2;
        void var1_1;
        this.status = var1_1;
        this.remoteError = var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasRemoteError() {
        if (this.remoteError == null) return false;
        return true;
    }

    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status Ok;
        public static final /* enum */ Status Error;
        private static final /* synthetic */ Status[] $VALUES;

        public static Status valueOf(String name) {
            String string;
            return Enum.valueOf(Status.class, string);
        }

        static {
            Status status;
            Ok = status = new Status();
            Error = status = new Status();
            $VALUES = statusArray = new Status[]{Status.Ok, Status.Error};
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class RemoteError {
        private static final String TAG = "RemoteError";
        public static final int REMOTE_ESPRESSO_ERROR_CODE = 0;
        public static final int REMOTE_PROTOCOL_ERROR_CODE = 1;
        private static final RemoteError REMOTE_ESPRESSO_ERROR;
        private static final RemoteError REMOTE_PROTOCOL_ERROR;
        private static final SparseArray<RemoteError> lookup;
        private final int code;
        private final String description;

        public int getCode() {
            return this.code;
        }

        private static RemoteError getWellKnownError(int errorCode) {
            int n;
            return (RemoteError)lookup.get(n);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String formatDescription(String description, int errorCode, String detailedError) {
            String string;
            void var2_4;
            boolean bl = !TextUtils.isEmpty((CharSequence)description);
            Preconditions.checkState(bl, "description cannot be empty!");
            if (var2_4 == null) return string;
            try {
                void var1_1;
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{(int)var1_1, var2_4};
                String string2 = String.format(locale, string, objectArray);
                return string2;
            }
            catch (IllegalFormatException illegalFormatException) {
                StringBuilder stringBuilder = new StringBuilder();
                Log.w((String)TAG, (String)stringBuilder.append("Cannot format remote error description: ").append(string).toString());
                return string;
            }
        }

        public String getDescription() {
            return this.description;
        }

        /*
         * WARNING - void declaration
         */
        static String getWellKnownFormattedErrorDescription(int errorCode, String detailedError) {
            void var1_1;
            int n;
            Preconditions.checkState(RemoteError.isWellKnownError(errorCode));
            return RemoteError.formatDescription(RemoteError.getWellKnownError(n).getDescription(), n, (String)var1_1);
        }

        public String toString() {
            int n = ((RemoteError)((Object)this_)).code;
            String this_ = ((RemoteError)((Object)this_)).description;
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append(n).append(": ").append(this_).toString();
        }

        static {
            Object object = new RemoteError(0, "The following remote Espresso exception with error code [%s] occurred:\n%s");
            REMOTE_ESPRESSO_ERROR = object;
            object = new RemoteError(1, "The following remote protocol Espresso exception with error code [%s] occurred:\n%s");
            REMOTE_PROTOCOL_ERROR = object;
            object = new SparseArray();
            lookup = object;
            object = new RemoteError[]{REMOTE_ESPRESSO_ERROR, REMOTE_PROTOCOL_ERROR};
            for (RemoteError remoteError : Arrays.asList(object)) {
                lookup.put(remoteError.getCode(), (Object)remoteError);
            }
        }

        /*
         * WARNING - void declaration
         */
        RemoteError(int code, String description) {
            void var2_2;
            void var1_1;
            this.code = var1_1;
            this.description = var2_2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isWellKnownError(int errorCode) {
            int n;
            if (lookup.get(n) == null) return 0 != 0;
            return 1 != 0;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private Status status;
        private RemoteError remoteError;
        private byte[] interactionResultProtoByteArray;

        /*
         * WARNING - void declaration
         */
        public Builder setRemoteError(RemoteError remoteError) {
            void var1_1;
            this.remoteError = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setResultProto(byte[] protoByteArray) {
            void var1_1;
            this.interactionResultProtoByteArray = (byte[])Preconditions.checkNotNull(var1_1, "protoByteArray cannot benull!");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setStatus(Status status) {
            void var1_1;
            this.status = (Status)((Object)Preconditions.checkNotNull(var1_1));
            return this;
        }

        public InteractionResponse build() {
            Object this_;
            if ((((Builder)this_).status != null || ((Builder)this_).remoteError != null) && ((Builder)this_).interactionResultProtoByteArray != null) {
                this_ = new RemoteProtocolException("Instances can either be create from an status and optional remote error or an interaction result proto byte array but not both!");
                throw this_;
            }
            if (((Builder)this_).interactionResultProtoByteArray != null) {
                try {
                    this_ = ((Builder)this_).interactionResultProtoByteArray;
                    this_ = UiInteraction.InteractionResultProto.parseFrom((byte[])this_);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    RemoteProtocolException remoteProtocolException = new RemoteProtocolException("Cannot parse interactionResultProto", (Throwable)invalidProtocolBufferException);
                    throw remoteProtocolException;
                }
                return (InteractionResponse)FROM.fromProto(this_);
            }
            InteractionResponse interactionResponse = new InteractionResponse((Builder)this_, null);
            return interactionResponse;
        }
    }
}

