/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.view.View;
import androidx.test.espresso.Root;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.proto.UiInteraction;
import androidx.test.espresso.remote.EspressoRemoteMessage;
import androidx.test.espresso.remote.InteractionRequest-IA;
import androidx.test.espresso.remote.RemoteDescriptorRegistry;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.espresso.remote.TypeProtoConverters;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLite;
import org.hamcrest.Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class InteractionRequest
implements EspressoRemoteMessage.To<MessageLite> {
    private static final EspressoRemoteMessage.From<InteractionRequest, UiInteraction.InteractionRequestProto> FROM;
    private final Matcher<Root> rootMatcher;
    private final Matcher<View> viewMatcher;
    private final ViewAction viewAction;
    private final ViewAssertion viewAssertion;

    public ViewAction getViewAction() {
        return this.viewAction;
    }

    public ViewAssertion getViewAssertion() {
        return this.viewAssertion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageLite toProto() {
        try {
            UiInteraction.InteractionRequestProto.Builder builder = UiInteraction.InteractionRequestProto.newBuilder();
            ViewAction viewAction = ((InteractionRequest)this).rootMatcher;
            builder.setRootMatcher(TypeProtoConverters.typeToAny(viewAction));
            viewAction = ((InteractionRequest)this).viewMatcher;
            if (viewAction != null) {
                builder.setViewMatcher(TypeProtoConverters.typeToAny(((InteractionRequest)this).viewMatcher));
            }
            if ((viewAction = ((InteractionRequest)this).viewAction) != null) {
                builder.setViewAction(TypeProtoConverters.typeToAny(((InteractionRequest)this).viewAction));
            }
            if ((viewAction = ((InteractionRequest)this).viewAssertion) == null) return builder.build();
            builder.setViewAssertion(TypeProtoConverters.typeToAny(((InteractionRequest)this).viewAssertion));
            return builder.build();
        }
        catch (ClassCastException classCastException) {
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException("Type does not implement the EspressoRemoteMessage.TO interface", (Throwable)classCastException);
            throw remoteProtocolException;
        }
    }

    public Matcher<Root> getRootMatcher() {
        return this.rootMatcher;
    }

    public Matcher<View> getViewMatcher() {
        return this.viewMatcher;
    }

    static {
        EspressoRemoteMessage.From<InteractionRequest, UiInteraction.InteractionRequestProto> from;
        FROM = from = new EspressoRemoteMessage.From<InteractionRequest, UiInteraction.InteractionRequestProto>(){

            /*
             * WARNING - void declaration
             */
            public InteractionRequest fromProto(UiInteraction.InteractionRequestProto interactionRequestProto) {
                void var1_1;
                Object object = new Builder();
                ((Builder)object).setRootMatcher((Matcher<Root>)((Matcher)TypeProtoConverters.anyToType(var1_1.getRootMatcher()))).setViewMatcher((Matcher<View>)((Matcher)TypeProtoConverters.anyToType(var1_1.getViewMatcher())));
                int n = var1_1.getActionOrAssertionCase().getNumber();
                if (UiInteraction.InteractionRequestProto.ActionOrAssertionCase.VIEW_ACTION.getNumber() == n) {
                    ((Builder)object).setViewAction((ViewAction)TypeProtoConverters.anyToType(var1_1.getViewAction()));
                }
                if (UiInteraction.InteractionRequestProto.ActionOrAssertionCase.VIEW_ASSERTION.getNumber() == n) {
                    ((Builder)object).setViewAssertion((ViewAssertion)TypeProtoConverters.anyToType(var1_1.getViewAssertion()));
                }
                return ((Builder)object).build();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private InteractionRequest(Builder builder) {
        this((Matcher<Root>)((Builder)var1_1).rootMatcher, (Matcher<View>)((Builder)var1_1).viewMatcher, ((Builder)var1_1).viewAction, ((Builder)var1_1).viewAssertion);
        void var1_1;
    }

    /* synthetic */ InteractionRequest(Builder builder, InteractionRequest-IA interactionRequest-IA) {
        this(builder);
    }

    /*
     * WARNING - void declaration
     */
    InteractionRequest(Matcher<Root> rootMatcher, Matcher<View> viewMatcher, ViewAction viewAction, ViewAssertion viewAssertion) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.rootMatcher = var1_1;
        this.viewMatcher = var2_2;
        this.viewAction = var3_3;
        this.viewAssertion = var4_4;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private final RemoteDescriptorRegistry remoteDescriptorRegistry = RemoteDescriptorRegistry.getInstance();
        private Matcher<Root> rootMatcher;
        private Matcher<View> viewMatcher;
        private ViewAction viewAction;
        private ViewAssertion viewAssertion;
        private byte[] interactionRequestProtoByteArray;

        /*
         * WARNING - void declaration
         */
        public Builder setRequestProto(byte[] protoByteArray) {
            void var1_1;
            this.interactionRequestProtoByteArray = (byte[])Preconditions.checkNotNull(var1_1, "protoByteArray cannot be null!");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRootMatcher(Matcher<Root> rootMatcher) {
            void var1_1;
            this.rootMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
            Preconditions.checkArgument(this.remoteDescriptorRegistry.hasArgForInstanceType(var1_1.getClass()), "No RemoteDescriptor registered for ViewMatcher: %s", var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewAction(ViewAction viewAction) {
            void var1_1;
            this.viewAction = (ViewAction)Preconditions.checkNotNull(var1_1);
            Preconditions.checkArgument(this.remoteDescriptorRegistry.hasArgForInstanceType(var1_1.getClass()), "No RemoteDescriptor registered for ViewAction: %s", var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewAssertion(ViewAssertion viewAssertion) {
            void var1_1;
            this.viewAssertion = (ViewAssertion)Preconditions.checkNotNull(var1_1);
            Preconditions.checkArgument(this.remoteDescriptorRegistry.hasArgForInstanceType(var1_1.getClass()), "No RemoteDescriptor registered for ViewAssertion: %s", var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setViewMatcher(Matcher<View> viewMatcher) {
            void var1_1;
            this.viewMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
            Preconditions.checkArgument(this.remoteDescriptorRegistry.hasArgForInstanceType(var1_1.getClass()), "No RemoteDescriptor registered for ViewMatcher: %s", var1_1);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InteractionRequest build() {
            Object this_;
            if (((Builder)this_).viewAction != null && ((Builder)this_).viewAssertion != null) {
                this_ = new IllegalStateException("View Action and Assertion set. Either set a View Action or a View Assertion but not both at the same time!");
                throw this_;
            }
            if ((((Builder)this_).viewMatcher != null || ((Builder)this_).viewAction != null || ((Builder)this_).viewAssertion != null) && ((Builder)this_).interactionRequestProtoByteArray != null) {
                this_ = new IllegalStateException("Instances can either be create from an view matcher. view action and assertion or an interaction request proto byte array but not both!");
                throw this_;
            }
            if (((Builder)this_).interactionRequestProtoByteArray != null) {
                try {
                    this_ = ((Builder)this_).interactionRequestProtoByteArray;
                    this_ = UiInteraction.InteractionRequestProto.parseFrom((byte[])this_);
                    return (InteractionRequest)FROM.fromProto(this_);
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    RemoteProtocolException remoteProtocolException = new RemoteProtocolException("Cannot parse interactionResultProto", (Throwable)invalidProtocolBufferException);
                    throw remoteProtocolException;
                }
            }
            boolean bl = ((Builder)this_).rootMatcher != null;
            Preconditions.checkState(bl, "root matcher is mandatory and needs to be set using:Builder.setRootMatcher(Matcher)");
            return new InteractionRequest((Builder)this_, null);
        }
    }
}

