/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

public final class FieldDescriptor {
    public final Class<?> fieldType;
    public final String fieldName;
    public final int order;

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n = this.fieldType != null ? this.fieldType.hashCode() : 0;
        int n2 = n * 31;
        if (this.fieldName != null) {
            n = this.fieldName.hashCode();
            return (n2 + n) * 31 + this.order;
        }
        n = 0;
        return (n2 + n) * 31 + this.order;
    }

    /*
     * WARNING - void declaration
     */
    static FieldDescriptor of(Field field, RemoteMsgField remoteMsgFieldAnnotation) {
        Field field2;
        void var1_1;
        Preconditions.checkNotNull(field, "field cannot be null");
        Preconditions.checkNotNull(var1_1, "remoteMsgFieldAnnotation cannot be null");
        return FieldDescriptor.of(field2.getType(), field2.getName(), var1_1.order());
    }

    /*
     * WARNING - void declaration
     */
    public static FieldDescriptor of(Class<?> fieldType, String fieldName, int order) {
        void var2_2;
        void var1_1;
        Class<?> clazz;
        FieldDescriptor fieldDescriptor = new FieldDescriptor(clazz, (String)var1_1, (int)var2_2);
        return fieldDescriptor;
    }

    static List<FieldDescriptor> getFieldDescriptorsFromAnnotation(Class<?> clazz, Class<RemoteMsgField> annotation) {
        Class<?> clazz2;
        Object[] objectArray = new TreeMap();
        for (Field field : clazz2.getDeclaredFields()) {
            Locale locale;
            if (!field.isAnnotationPresent((Class<? extends Annotation>)((Object)locale))) continue;
            RemoteMsgField remoteMsgField = (RemoteMsgField)field.getAnnotation(locale);
            int n = remoteMsgField.order();
            if (objectArray.containsKey(n)) {
                locale = Locale.ROOT;
                objectArray = new Object[]{n, field.getName()};
                IllegalStateException illegalStateException = new IllegalStateException(String.format(locale, "Duplicate field order %s for field %s", objectArray));
                throw illegalStateException;
            }
            objectArray.put(n, FieldDescriptor.of(field, remoteMsgField));
        }
        return ImmutableList.copyOf(objectArray.values());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private FieldDescriptor(Class<?> fieldType, String fieldName, int order) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.fieldType = (Class)Preconditions.checkNotNull(var1_1, "fieldType cannot be null!");
        this.fieldName = (String)Preconditions.checkNotNull(var2_3, "fieldName cannot be null!");
        boolean bl = var3_4 >= 0;
        Preconditions.checkState(bl, "Field order must be greater then or equal to 0!");
        this.order = var3_4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object o) {
        FieldDescriptor fieldDescriptor;
        if (this == fieldDescriptor) {
            return true;
        }
        if (fieldDescriptor == null) return false;
        if (this.getClass() != fieldDescriptor.getClass()) {
            return false;
        }
        fieldDescriptor = fieldDescriptor;
        if (this.order != fieldDescriptor.order) {
            return false;
        }
        if (this.fieldType != null ? !this.fieldType.equals(fieldDescriptor.fieldType) : fieldDescriptor.fieldType != null) {
            return false;
        }
        if (this.fieldName != null) {
            return this.fieldName.equals(fieldDescriptor.fieldName);
        }
        if (fieldDescriptor.fieldName != null) return false;
        return true;
    }
}

