/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.DataInteractionRemote;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.Root;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.action.RemoteViewActions;
import androidx.test.espresso.assertion.RemoteViewAssertions;
import androidx.test.espresso.matcher.RemoteHamcrestCoreMatchers13;
import androidx.test.espresso.matcher.RemoteRootMatchers;
import androidx.test.espresso.matcher.RemoteViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.remote.IInteractionExecutionStatus;
import androidx.test.espresso.remote.InteractionRequest;
import androidx.test.espresso.remote.InteractionResponse;
import androidx.test.espresso.remote.NoRemoteEspressoInstanceException;
import androidx.test.espresso.remote.RemoteDescriptorRegistry;
import androidx.test.espresso.remote.RemoteEspressoException;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.remote.RemoteInteractionRegistry;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.guava.base.Throwables;
import androidx.test.espresso.web.action.RemoteWebActions;
import androidx.test.espresso.web.assertion.RemoteWebViewAssertions;
import androidx.test.espresso.web.matcher.RemoteWebMatchers;
import androidx.test.espresso.web.model.RemoteWebModelAtoms;
import androidx.test.espresso.web.sugar.RemoteWebSugar;
import androidx.test.espresso.web.webdriver.RemoteWebDriverAtoms;
import androidx.test.internal.runner.InstrumentationConnection;
import androidx.test.internal.util.LogUtil;
import androidx.test.internal.util.ParcelableIBinder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class EspressoRemote
implements RemoteInteraction {
    private static final String TAG = "EspressoRemote";
    private static final EspressoRemote DEFAULT_INSTANCE;
    static final String TYPE;
    static final String BUNDLE_KEY_TYPE = "type";
    static final String BUNDLE_KEY_UUID = "uuid";
    static final String BUNDLE_KEY_PROTO = "proto";
    static InstrumentationConnection instrumentationConnection;
    private static final int MSG_TERMINATE = 1;
    private static final int MSG_FORWARD_TO_REMOTE_ESPRESSO = 2;
    static final int MSG_HANDLE_ESPRESSO_REQUEST = 3;
    static final int MSG_HANDLE_ESPRESSO_RESPONSE = 4;
    static final int MSG_HANDLE_EMPTY_REQUEST = 5;
    private static volatile boolean isRemoteProcess;
    IncomingHandler incomingHandler;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized ResponseHolder sendMessageSynchronously(int what, byte[] data, Map<String, IBinder> iBinders) throws InterruptedException {
        InterruptedException interruptedException2;
        String string;
        Object[] objectArray;
        Object object;
        void var1_1;
        Object object2;
        UUID uUID;
        block6: {
            void var2_3;
            uUID = UUID.randomUUID();
            object2 = Locale.ROOT;
            object = new Object[]{(int)var1_1, uUID};
            LogUtil.logDebugWithProcess((String)TAG, (String)String.format((Locale)object2, "Sending sync msg [%s] with uuid [%s]", object), (Object[])new Object[0]);
            object2 = new CountDownLatch(1);
            object = new ResponseHolder((CountDownLatch)object2);
            objectArray = this.incomingHandler.getEspressoMessage(2);
            objectArray.arg1 = var1_1;
            Bundle bundle = objectArray.getData();
            bundle.putSerializable(BUNDLE_KEY_UUID, (Serializable)uUID);
            if (var2_3 != null) {
                bundle.putByteArray(BUNDLE_KEY_PROTO, (byte[])var2_3);
            }
            EspressoRemote.setIBindersToBundle((Map<String, IBinder>)((Object)string), bundle);
            objectArray.setData(bundle);
            this.incomingHandler.associateResponse(uUID, (ResponseHolder)object);
            this.incomingHandler.sendMessage((Message)objectArray);
            try {
                ((CountDownLatch)object2).await();
            }
            catch (InterruptedException interruptedException2) {
                try {
                    string = TAG;
                    object2 = Locale.ROOT;
                    object = "Interrupted while waiting for a response from msg [%s] with uuid [%s]";
                    objectArray = new Object[2];
                    break block6;
                }
                catch (Throwable throwable) {
                    this.incomingHandler.disassociateResponse(uUID);
                    throw throwable;
                }
            }
            this.incomingHandler.disassociateResponse(uUID);
            return object;
        }
        objectArray[0] = (int)var1_1;
        objectArray[1] = uUID;
        Log.w((String)string, (String)String.format((Locale)object2, (String)object, objectArray), (Throwable)interruptedException2);
        this.sendEmptyRequest();
        Thread.currentThread().interrupt();
        throw interruptedException2;
    }

    public static EspressoRemote getInstance() {
        return DEFAULT_INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Callable<Void> createRemoteCheckCallable(Matcher<Root> rootMatcher, Matcher<View> viewMatcher, Map<String, IBinder> iBinders, ViewAssertion viewAssertion) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Runnable runnable = new Runnable(){
            final /* synthetic */ ViewAssertion val$viewAssertion;
            final /* synthetic */ Matcher val$rootMatcher;
            final /* synthetic */ Matcher val$viewMatcher;
            final /* synthetic */ Map val$iBinders;
            final /* synthetic */ EspressoRemote this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$viewAssertion = viewAssertion;
                this.val$rootMatcher = matcher;
                this.val$viewMatcher = matcher2;
                this.val$iBinders = map;
            }

            @Override
            public void run() {
                Object object = Locale.ROOT;
                Object[] objectArray = new Object[]{this.val$viewAssertion};
                Log.i((String)EspressoRemote.TAG, (String)String.format((Locale)object, "Attempting to run check interaction on a remote process for ViewAssertion: %s", objectArray));
                object = new InteractionRequest.Builder();
                objectArray = this.val$rootMatcher;
                object = ((InteractionRequest.Builder)object).setRootMatcher((Matcher<Root>)objectArray);
                objectArray = this.val$viewMatcher;
                object = ((InteractionRequest.Builder)object).setViewMatcher((Matcher<View>)objectArray);
                objectArray = this.val$viewAssertion;
                object = ((InteractionRequest.Builder)object).setViewAssertion((ViewAssertion)objectArray);
                object = ((InteractionRequest.Builder)object).build();
                this.this$0.initiateRemoteCall(((InteractionRequest)object).toProto().toByteArray(), this.val$iBinders);
            }
        };
        return this.createRemoteInteraction(runnable);
    }

    /*
     * WARNING - void declaration
     */
    private Callable<Void> createRemoteInteraction(Runnable runnable) {
        void var1_1;
        Callable<Void> callable = new Callable<Void>(){
            final /* synthetic */ Runnable val$runnable;
            final /* synthetic */ EspressoRemote this$0;

            @Override
            public Void call() throws InterruptedException {
                long[] lArray = new long[]{10L, 50L, 100L, 500L, TimeUnit.SECONDS.toMillis(2L), TimeUnit.SECONDS.toMillis(30L)};
                int n = 0;
                while (true) {
                    if (n < 6) {
                        long l = lArray[n];
                        StringBuilder stringBuilder = new StringBuilder();
                        Log.i((String)EspressoRemote.TAG, (String)stringBuilder.append("No remote Espresso instance - waiting: ").append(l).append("ms for one to start").toString());
                        Thread.sleep(l);
                        if (this_.this$0.hasRemoteEspressoInstances()) {
                            this_.val$runnable.run();
                            return null;
                        }
                    } else {
                        3 this_ = new NoRemoteEspressoInstanceException("No remote Espresso instances at this time.");
                        throw this_;
                    }
                    ++n;
                }
            }
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$runnable = runnable;
            }
        };
        return callable;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Callable<Void> createRemotePerformCallable(Matcher<Root> rootMatcher, Matcher<View> viewMatcher, Map<String, IBinder> iBinders, ViewAction ... viewActions) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        Runnable runnable = new Runnable(){
            final /* synthetic */ ViewAction[] val$viewActions;
            final /* synthetic */ Matcher val$rootMatcher;
            final /* synthetic */ Matcher val$viewMatcher;
            final /* synthetic */ Map val$iBinders;
            final /* synthetic */ EspressoRemote this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$viewActions = viewActionArray;
                this.val$rootMatcher = matcher;
                this.val$viewMatcher = matcher2;
                this.val$iBinders = map;
            }

            @Override
            public void run() {
                for (ViewAction viewAction : this.val$viewActions) {
                    Object object = Locale.ROOT;
                    Object[] objectArray = new Object[]{viewAction};
                    Log.i((String)EspressoRemote.TAG, (String)String.format((Locale)object, "Attempting to run perform interaction on a remote processes for ViewAction: %s", objectArray));
                    object = new InteractionRequest.Builder();
                    objectArray = this.val$rootMatcher;
                    object = ((InteractionRequest.Builder)object).setRootMatcher((Matcher<Root>)objectArray);
                    objectArray = this.val$viewMatcher;
                    object = ((InteractionRequest.Builder)object).setViewMatcher((Matcher<View>)objectArray);
                    InteractionRequest.Builder builder = ((InteractionRequest.Builder)object).setViewAction(viewAction);
                    InteractionRequest object2 = builder.build();
                    this.this$0.initiateRemoteCall(object2.toProto().toByteArray(), this.val$iBinders);
                }
            }
        };
        return this.createRemoteInteraction(runnable);
    }

    static {
        EspressoRemote espressoRemote;
        DEFAULT_INSTANCE = espressoRemote = new EspressoRemote();
        TYPE = EspressoRemote.class.getCanonicalName();
    }

    private EspressoRemote() {
        this(InstrumentationConnection.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    EspressoRemote(InstrumentationConnection instrumentationConnection) {
        void var1_1;
        EspressoRemote.instrumentationConnection = var1_1;
    }

    public synchronized void init() {
        LogUtil.logDebugWithProcess((String)TAG, (String)"init called", (Object[])new Object[0]);
        if (this.incomingHandler == null) {
            String string = TYPE;
            Object object = new StringBuilder();
            Log.i((String)TAG, (String)object.append("Initializing Espresso Remote of type: ").append(string).toString());
            RemoteInteractionRegistry.registerInstance((RemoteInteraction)DEFAULT_INSTANCE);
            EspressoRemote.initRemoteRegistry();
            string = new HandlerThread("EspressoRemoteThread");
            string.start();
            object = new IncomingHandler(this, string.getLooper());
            this.incomingHandler = object;
            instrumentationConnection.registerClient(TYPE, this.incomingHandler.messengerHandler);
            return;
        }
    }

    private static void initRemoteRegistry() {
        RemoteDescriptorRegistry remoteDescriptorRegistry = RemoteDescriptorRegistry.getInstance();
        RemoteRootMatchers.init(remoteDescriptorRegistry);
        RemoteViewMatchers.init(remoteDescriptorRegistry);
        RemoteViewActions.init(remoteDescriptorRegistry);
        RemoteViewAssertions.init(remoteDescriptorRegistry);
        RemoteHamcrestCoreMatchers13.init(remoteDescriptorRegistry);
        DataInteractionRemote.init(remoteDescriptorRegistry);
        RemoteWebActions.init(remoteDescriptorRegistry);
        RemoteWebModelAtoms.init(remoteDescriptorRegistry);
        RemoteWebSugar.init(remoteDescriptorRegistry);
        RemoteWebDriverAtoms.init(remoteDescriptorRegistry);
        RemoteWebViewAssertions.init(remoteDescriptorRegistry);
        RemoteWebMatchers.init(remoteDescriptorRegistry);
    }

    /*
     * WARNING - void declaration
     */
    void initiateRemoteCall(byte[] data, Map<String, IBinder> iBinders) {
        LogUtil.logDebugWithProcess((String)TAG, (String)"initiateRemoteCall", (Object[])new Object[0]);
        try {
            void var2_2;
            void var1_1;
            EspressoRemote.reportResults(this.sendMessageSynchronously(3, (byte[])var1_1, (Map<String, IBinder>)var2_2));
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private static void remoteInit() {
        LogUtil.logDebugWithProcess((String)TAG, (String)"remoteInit called", (Object[])new Object[0]);
        EspressoRemote.getInstance().init();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void reportResults(ResponseHolder responseHolder) {
        block5: {
            Object object;
            Object object2 = responseHolder.getData().getByteArray(BUNDLE_KEY_PROTO);
            if (object2 == null) {
                object2 = new IllegalStateException("Espresso remote response doesn't contain a valid response");
                throw object2;
            }
            try {
                InteractionResponse.Builder builder = new InteractionResponse.Builder();
                object2 = builder.setResultProto((byte[])object2).build();
                InteractionResponse.Status status = InteractionResponse.Status.Error;
                object = ((InteractionResponse)object2).getStatus();
                if (status != object) break block5;
            }
            catch (RemoteProtocolException remoteProtocolException) {
                Log.e((String)TAG, (String)"Could not parse Interaction response", (Throwable)remoteProtocolException);
                RemoteEspressoException remoteEspressoException = new RemoteEspressoException("Could not parse Interaction response", (Throwable)remoteProtocolException);
                throw remoteEspressoException;
            }
            {
                boolean bl = ((InteractionResponse)object2).hasRemoteError();
                if (!bl) {
                    object2 = String.valueOf(object2);
                    object = new StringBuilder();
                    IllegalStateException illegalStateException = new IllegalStateException(((StringBuilder)object).append("Interaction response reported Status.Error, but noerror message was attached to interaction response: ").append((String)object2).toString());
                    throw illegalStateException;
                }
                RemoteEspressoException remoteEspressoException = new RemoteEspressoException(((InteractionResponse)object2).getRemoteError().getDescription());
                throw remoteEspressoException;
            }
        }
    }

    private void sendEmptyRequest() {
        LogUtil.logDebugWithProcess((String)TAG, (String)"sendEmptyRequest", (Object[])new Object[0]);
        try {
            this.sendMessageSynchronously(5, null, null);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setIBindersToBundle(Map<String, IBinder> iBinders, Bundle bundle) {
        Object object;
        if (iBinders != null && !object.isEmpty()) {
            for (Map.Entry entry : object.entrySet()) {
                void var1_1;
                Object object2 = entry.getKey();
                object2 = (String)object2;
                ParcelableIBinder parcelableIBinder = new ParcelableIBinder((IBinder)entry.getValue());
                var1_1.putParcelable(object2, (Parcelable)parcelableIBinder);
            }
        }
    }

    public synchronized void terminate() {
        LogUtil.logDebugWithProcess((String)TAG, (String)"terminate called", (Object[])new Object[0]);
        if (this.incomingHandler != null) {
            this.incomingHandler.getEspressoMessage(1).sendToTarget();
            this.incomingHandler = null;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized boolean hasRemoteEspressoInstances() {
        if (instrumentationConnection.getClientsForType(TYPE).size() <= 1) return false;
        return true;
    }

    public synchronized boolean isRemoteProcess() {
        return isRemoteProcess;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class IncomingHandler
    extends Handler {
        private final Map<UUID, ResponseHolder> responses;
        Messenger messengerHandler;
        final /* synthetic */ EspressoRemote this$0;

        /*
         * WARNING - void declaration
         */
        private Message getEspressoMessage(int what) {
            void var1_1;
            Message message = this_.this$0.incomingHandler.obtainMessage((int)var1_1);
            message.replyTo = this_.messengerHandler;
            IncomingHandler this_ = new Bundle();
            this_.putString(EspressoRemote.BUNDLE_KEY_TYPE, TYPE);
            message.setData((Bundle)this_);
            return message;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private InteractionResponse executeRequest(Bundle data) {
            block10: {
                block11: {
                    this /* !! */  = (IncomingHandler)data.getByteArray("proto");
                    var2_8 = InteractionResponse.Status.Error;
                    try {
                        var3_9 = new InteractionRequest.Builder();
                        var3_9 = var3_9.setRequestProto((byte[])this /* !! */ ).build();
                        this /* !! */  = (ParcelableIBinder)var1_7.getParcelable("executionStatus");
                        if (this /* !! */  == null) break block10;
                        this /* !! */  = this /* !! */ .getIBinder();
                        this /* !! */  = IInteractionExecutionStatus.Stub.asInterface((IBinder)this /* !! */ );
                        var0_1 = this /* !! */ .canExecute();
                        break block11;
                    }
                    catch (RemoteProtocolException var0_3) {
                        var1_7 = new InteractionResponse.RemoteError(1, Throwables.getStackTraceAsString(var0_3));
                        var0_2 /* !! */  = var2_8;
                    }
lbl16:
                    // 4 sources

                    while (true) {
                        var2_8 = new InteractionResponse.Builder();
                        return var2_8.setStatus(var0_2 /* !! */ ).setRemoteError((InteractionResponse.RemoteError)var1_7).build();
                    }
                    catch (RuntimeException var0_4) {
                        var1_7 = new InteractionResponse.RemoteError(0, Throwables.getStackTraceAsString(var0_4));
                        var0_2 /* !! */  = var2_8;
                    }
                    catch (Error var0_5) {
                        var1_7 = new InteractionResponse.RemoteError(0, Throwables.getStackTraceAsString(var0_5));
                        var0_2 /* !! */  = var2_8;
                    }
lbl-1000:
                    // 1 sources

                    {
                        while (true) {
                            var1_7 = new RuntimeException("Unable to query interaction execution status", var0_6.getCause());
                            throw var1_7;
                        }
                    }
                    catch (RemoteException var0_6) {
                        ** continue;
                    }
                }
lbl33:
                // 2 sources

                while (true) {
                    var0_2 /* !! */  = var0_1 != false ? RemoteInteractionStrategy.from((InteractionRequest)var3_9, (Bundle)var1_7).execute() : var2_8;
                    var1_7 = null;
                    ** continue;
                    break;
                }
            }
            var0_1 = false;
            ** while (true)
        }

        /*
         * WARNING - void declaration
         */
        public IncomingHandler(EspressoRemote this$0, Looper looper) {
            void var2_3;
            Messenger messenger;
            this.this$0 = messenger;
            super((Looper)var2_3);
            messenger = new HashMap();
            this.responses = messenger;
            this.messengerHandler = messenger = new Messenger((Handler)this);
            if (Looper.getMainLooper() == var2_3 || Looper.myLooper() == var2_3) {
                IllegalStateException illegalStateException = new IllegalStateException("This handler should not be using the main thread looper nor the instrumentation thread looper.");
                throw illegalStateException;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void associateResponse(UUID latchId, ResponseHolder response) {
            void var2_4;
            IllegalStateException illegalStateException;
            Callable<Void> callable = new Callable<Void>(){
                final /* synthetic */ UUID val$latchId;
                final /* synthetic */ ResponseHolder val$response;
                final /* synthetic */ IncomingHandler this$1;

                @Override
                public Void call() {
                    this.this$1.responses.put(this.val$latchId, this.val$response);
                    return null;
                }
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$latchId = uUID;
                    this.val$response = responseHolder;
                }
            };
            FutureTask<Void> futureTask = new FutureTask<Void>(callable);
            this.post(futureTask);
            try {
                futureTask.get();
                return;
            }
            catch (ExecutionException executionException) {
                illegalStateException = new IllegalStateException(executionException.getCause());
                throw illegalStateException;
            }
            catch (InterruptedException interruptedException) {
                illegalStateException = new IllegalStateException(interruptedException);
                throw illegalStateException;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void disassociateResponse(UUID latchId) {
            IllegalStateException illegalStateException;
            Callable<Void> callable = new Callable<Void>(){
                final /* synthetic */ UUID val$latchId;
                final /* synthetic */ IncomingHandler this$1;

                @Override
                public Void call() {
                    this.this$1.responses.remove(this.val$latchId);
                    return null;
                }
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$latchId = uUID;
                }
            };
            FutureTask<Void> futureTask = new FutureTask<Void>(callable);
            this.post(futureTask);
            try {
                futureTask.get();
                return;
            }
            catch (ExecutionException executionException) {
                illegalStateException = new IllegalStateException(executionException.getCause());
                throw illegalStateException;
            }
            catch (InterruptedException interruptedException) {
                illegalStateException = new IllegalStateException(interruptedException);
                throw illegalStateException;
            }
        }

        private void doDie() {
            instrumentationConnection.unregisterClient(TYPE, this.messengerHandler);
            this.getLooper().quit();
        }

        /*
         * WARNING - void declaration
         */
        private void handleEspressoRequest(Messenger caller, Bundle data) {
            void var1_2;
            void var2_3;
            UUID uUID = (UUID)data.getSerializable(EspressoRemote.BUNDLE_KEY_UUID);
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{uUID};
            LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)String.format(locale, "handleEspressoRequest for id: %s", objectArray), (Object[])new Object[0]);
            locale = this.getEspressoMessage(4);
            objectArray = locale.getData();
            objectArray.putSerializable(EspressoRemote.BUNDLE_KEY_UUID, (Serializable)uUID);
            isRemoteProcess = true;
            objectArray.putByteArray(EspressoRemote.BUNDLE_KEY_PROTO, this.executeRequest((Bundle)var2_3).toProto().toByteArray());
            locale.setData((Bundle)objectArray);
            try {
                var1_2.send((Message)locale);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w((String)EspressoRemote.TAG, (String)"The remote caller process is terminated unexpectedly", (Throwable)remoteException);
                instrumentationConnection.unregisterClient(TYPE, (Messenger)var1_2);
                return;
            }
        }

        private void handleEspressoResponse(Bundle data) {
            String string;
            Comparable<UUID> comparable = (UUID)data.getSerializable(EspressoRemote.BUNDLE_KEY_UUID);
            Object[] objectArray = new Object[]{comparable};
            LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"handleEspressoResponse for id: %s", (Object[])objectArray);
            Object object = ((IncomingHandler)((Object)object)).responses.get(comparable);
            if (object == null) {
                string = String.valueOf(comparable);
                comparable = new Comparable<UUID>();
                object = new IllegalStateException(((StringBuilder)comparable).append("Received a response from an unknown message: ").append(string).toString());
                throw object;
            }
            ((ResponseHolder)object).setData((Bundle)string);
            ((ResponseHolder)object).getLatch().countDown();
        }

        public void handleMessage(Message msg) {
            StringBuilder stringBuilder;
            msg.getData().setClassLoader(string.getClass().getClassLoader());
            if (!TYPE.equals(stringBuilder.getData().getString(EspressoRemote.BUNDLE_KEY_TYPE)) || ((Message)stringBuilder).replyTo == null) {
                String string = String.valueOf(stringBuilder);
                stringBuilder = new StringBuilder();
                Log.w((String)EspressoRemote.TAG, (String)stringBuilder.append("Type mismatch or no valid Messenger present, ignoring message: ").append(string).toString());
                return;
            }
            switch (((Message)stringBuilder).what) {
                default: {
                    int n = ((Message)stringBuilder).what;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    Log.w((String)EspressoRemote.TAG, (String)stringBuilder2.append("Unknown message code received: ").append(n).toString());
                    super.handleMessage((Message)stringBuilder);
                    return;
                }
                case 5: {
                    LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"handleMessage: MSG_HANDLE_EMPTY_REQUEST", (Object[])new Object[0]);
                    super.sendMsgToRemoteEspressos(4, stringBuilder.getData());
                    return;
                }
                case 4: {
                    LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"handleMessage: MSG_HANDLE_ESPRESSO_RESPONSE", (Object[])new Object[0]);
                    super.handleEspressoResponse(stringBuilder.getData());
                    return;
                }
                case 3: {
                    LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"handleMessage: MSG_HANDLE_ESPRESSO_REQUEST", (Object[])new Object[0]);
                    super.handleEspressoRequest(((Message)stringBuilder).replyTo, stringBuilder.getData());
                    return;
                }
                case 2: {
                    LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"handleMessage: MSG_FORWARD_TO_REMOTE_ESPRESSO", (Object[])new Object[0]);
                    super.sendMsgToRemoteEspressos(((Message)stringBuilder).arg1, stringBuilder.getData());
                    return;
                }
                case 1: 
            }
            LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"handleMessage: MSG_TERMINATE", (Object[])new Object[0]);
            ((IncomingHandler)((Object)string)).doDie();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendMsgToRemoteEspressos(int what, Bundle data) {
            Iterator iterator;
            void var1_1;
            LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"sendMsgToRemoteEspressos called", (Object[])new Object[0]);
            Message message = this.getEspressoMessage((int)var1_1);
            message.setData((Bundle)iterator);
            for (Messenger messenger : instrumentationConnection.getClientsForType(TYPE)) {
                if (this.messengerHandler.equals((Object)messenger)) continue;
                try {
                    messenger.send(message);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)EspressoRemote.TAG, (String)"The remote process is terminated unexpectedly", (Throwable)remoteException);
                    instrumentationConnection.unregisterClient(TYPE, messenger);
                }
            }
        }
    }

    private static class ResponseHolder {
        private final CountDownLatch latch;
        private Bundle data = null;

        public Bundle getData() {
            return this.data;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        /*
         * WARNING - void declaration
         */
        public ResponseHolder(CountDownLatch latch) {
            void var1_1;
            this.latch = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setData(Bundle data) {
            void var1_1;
            this.data = var1_1;
        }
    }

    private static class OnViewCheckStrategy
    extends RemoteInteractionStrategy {
        private final Matcher<Root> rootMatcher;
        private final Matcher<View> viewMatcher;
        private final ViewAssertion viewAssertion;

        @Override
        public InteractionResponse.Status execute() {
            Object[] objectArray = new Object[]{this.rootMatcher, this.viewMatcher, this.viewAssertion};
            LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"Remotely executing:\nonView(%S).inRoot(%s).check(%s)", (Object[])objectArray);
            Espresso.onView(this.viewMatcher).inRoot(this.rootMatcher).check(this.viewAssertion);
            return InteractionResponse.Status.Ok;
        }

        /*
         * WARNING - void declaration
         */
        public OnViewCheckStrategy(Matcher<Root> rootMatcher, Matcher<View> viewMatcher, ViewAssertion viewAssertion) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.rootMatcher = var1_1;
            this.viewMatcher = var2_2;
            this.viewAssertion = var3_3;
        }
    }

    private static class OnViewPerformStrategy
    extends RemoteInteractionStrategy {
        private final Matcher<Root> rootMatcher;
        private final Matcher<View> viewMatcher;
        private final ViewAction viewAction;

        @Override
        public InteractionResponse.Status execute() {
            Object[] objectArray = new Object[]{this.rootMatcher, this.viewMatcher, this.viewAction};
            LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"Remotely executing:\nonView(%s).inRoot(%s).perform(%s)", (Object[])objectArray);
            objectArray = this.viewMatcher;
            objectArray = Espresso.onView(objectArray);
            ViewAction[] viewActionArray = this.rootMatcher;
            objectArray = objectArray.inRoot(viewActionArray);
            viewActionArray = new ViewAction[]{this.viewAction};
            objectArray.perform(viewActionArray);
            return InteractionResponse.Status.Ok;
        }

        /*
         * WARNING - void declaration
         */
        public OnViewPerformStrategy(Matcher<Root> rootMatcher, Matcher<View> viewMatcher, ViewAction viewAction) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.rootMatcher = var1_1;
            this.viewMatcher = var2_2;
            this.viewAction = var3_3;
        }
    }

    static abstract class RemoteInteractionStrategy {
        public static RemoteInteractionStrategy from(InteractionRequest interactionRequest, Bundle bundle) {
            RemoteInteractionStrategy remoteInteractionStrategy;
            InteractionRequest interactionRequest2;
            Preconditions.checkNotNull(interactionRequest, "interactionRequest cannot be null!");
            Object[] objectArray = new Object[]{interactionRequest2.getRootMatcher(), interactionRequest2.getViewMatcher(), interactionRequest2.getViewAction(), interactionRequest2.getViewAssertion()};
            LogUtil.logDebugWithProcess((String)EspressoRemote.TAG, (String)"Creating RemoteInteractionStrategy from values:\nRootMatcher: %s\nViewMatcher: %s\nViewAction: %s\nView Assertion: %s", (Object[])objectArray);
            if (interactionRequest2.getViewAction() != null) {
                objectArray = interactionRequest2.getViewAction();
                RemoteInteractionStrategy.setIBinderFromBundle(objectArray, (Bundle)remoteInteractionStrategy);
                remoteInteractionStrategy = new OnViewPerformStrategy(interactionRequest2.getRootMatcher(), interactionRequest2.getViewMatcher(), (ViewAction)objectArray);
                return remoteInteractionStrategy;
            }
            objectArray = interactionRequest2.getViewAssertion();
            RemoteInteractionStrategy.setIBinderFromBundle(objectArray, (Bundle)remoteInteractionStrategy);
            remoteInteractionStrategy = new OnViewCheckStrategy(interactionRequest2.getRootMatcher(), interactionRequest2.getViewMatcher(), (ViewAssertion)objectArray);
            return remoteInteractionStrategy;
        }

        abstract InteractionResponse.Status execute();

        RemoteInteractionStrategy() {
        }

        /*
         * WARNING - void declaration
         */
        private static void setIBinderFromBundle(Bindable bindable, Bundle bundle) {
            Bindable bindable2;
            void var1_1;
            bindable.setIBinder(((ParcelableIBinder)var1_1.getParcelable(bindable2.getId())).getIBinder());
        }

        /*
         * WARNING - void declaration
         */
        private static void setIBinderFromBundle(Object object, Bundle bundle) {
            if (object instanceof Bindable) {
                void var1_1;
                Object object2;
                RemoteInteractionStrategy.setIBinderFromBundle((Bindable)object2, (Bundle)var1_1);
                return;
            }
        }
    }
}

