/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.test.espresso.remote.Converter;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import java.lang.reflect.Field;
import java.util.Locale;

final class ByteStringToParcelableConverter
implements Converter<ByteString, Parcelable> {
    private final Class<Parcelable> parcelableClass;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Parcelable convert(ByteString byteString) {
        Object object;
        Parcel parcel = Parcel.obtain();
        object = ((ByteString)object).toByteArray();
        try {
            parcel.unmarshall((byte[])object, 0, ((byte[])object).length);
            parcel.setDataPosition(0);
            object = this.parcelableClass;
            object = ((Class)object).getField("CREATOR");
            object = ((Field)object).get(null);
            object = (Parcelable.Creator)object;
            object = this.parcelableClass.cast(object.createFromParcel(parcel));
            if (parcel == null) return object;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Locale locale = Locale.ROOT;
            String string = "Cannot find CREATOR field for Parcelable %s";
            Object[] objectArray = new Object[]{this.parcelableClass.getName()};
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale, string, objectArray), (Throwable)noSuchFieldException);
            throw remoteProtocolException;
        }
        catch (IllegalAccessException illegalAccessException) {
            Locale locale = Locale.ROOT;
            String string = "Cannot create instance of %s. CREATOR field is inaccessible";
            Object[] objectArray = new Object[]{this.parcelableClass.getName()};
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale, string, objectArray), (Throwable)illegalAccessException);
            throw remoteProtocolException;
            {
                catch (Throwable throwable) {
                    if (parcel == null) {
                        throw throwable;
                    }
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
        parcel.recycle();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    ByteStringToParcelableConverter(Class<Parcelable> parcelableClass) {
        void var1_1;
        this.parcelableClass = (Class)Preconditions.checkNotNull(var1_1, "parcelableClass cannot be null!");
    }
}

