/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import androidx.test.espresso.remote.MethodInvocation;
import androidx.test.espresso.remote.ProtoUtils;
import androidx.test.espresso.remote.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.remote.internal.deps.protobuf.Any;
import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import java.util.Locale;

final class BuilderReflector {
    private static final String NEW_BUILDER_METHOD_NAME = "newBuilder";
    private static final String BUILDER_BUILD_METHOD_NAME = "build";
    private static final String BUILDER_SET_VALUE_METHOD_FTD_NAME = "set%s";
    private static final String BUILDER_ADD_ALL_LIST_METHOD_FTD_NAME = "addAll%s";
    final Object builderInstance;
    private final Class<?> builderType;

    /*
     * WARNING - void declaration
     */
    public BuilderReflector invokeAddAllAnyList(String methodSuffix, Object ... methodParams) {
        void var2_2;
        void var1_1;
        return this.invokeMethod(BUILDER_ADD_ALL_LIST_METHOD_FTD_NAME, (String)var1_1, Iterable.class, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private BuilderReflector invokeMethod(String methodNameTpl, String methodSuffix, Class<?> type, Object ... args) {
        void var3_3;
        String string;
        Class[] classArray;
        void var4_4;
        boolean bl = args != null && ((void)var4_4).length > 0;
        Preconditions.checkState(bl, "args set on builder %s, cannot be null or empty", this.builderType);
        Class<?> clazz = this.builderType;
        Object object = this.builderInstance;
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{ProtoUtils.capitalizeFirstChar((String)classArray)};
        string = String.format(locale, string, objectArray);
        classArray = new Class[]{var3_3};
        MethodInvocation methodInvocation = new MethodInvocation(clazz, object, string, classArray);
        methodInvocation.invokeDeclaredMethod((Object[])var4_4);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public BuilderReflector invokeSetAnyValue(String methodSuffix, Object ... methodParams) {
        void var2_2;
        void var1_1;
        return this.invokeMethod(BUILDER_SET_VALUE_METHOD_FTD_NAME, (String)var1_1, Any.class, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public BuilderReflector invokeSetByteStringValue(String methodSuffix, Object ... methodParams) {
        void var2_2;
        void var1_1;
        return this.invokeMethod(BUILDER_SET_VALUE_METHOD_FTD_NAME, (String)var1_1, ByteString.class, (Object[])var2_2);
    }

    public Object invokeBuild() {
        MethodInvocation methodInvocation = new MethodInvocation(this.builderType, this.builderInstance, BUILDER_BUILD_METHOD_NAME, new Class[0]);
        return methodInvocation.invokeMethod(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private Object newBuilderInstance(Class<?> protoType) {
        void var1_1;
        BuilderReflector builderReflector = new MethodInvocation((Class)var1_1, (Object)var1_1, NEW_BUILDER_METHOD_NAME, new Class[0]);
        return builderReflector.invokeMethod(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    BuilderReflector(Class<?> builderType, Class<?> protoType) {
        void var2_2;
        void var1_1;
        this.builderType = (Class)Preconditions.checkNotNull(var1_1, "builderType cannot be null");
        this.builderInstance = this.newBuilderInstance((Class)Preconditions.checkNotNull(var2_2, "protoType cannot be null"));
    }
}

