/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db.framework;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.Build;
import android.os.CancellationSignal;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteProgram;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.sqlite.db.framework.FrameworkSQLiteProgram;
import androidx.sqlite.db.framework.FrameworkSQLiteStatement;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

class FrameworkSQLiteDatabase
implements SupportSQLiteDatabase {
    private static final String[] CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final SQLiteDatabase mDelegate;

    FrameworkSQLiteDatabase(SQLiteDatabase delegate) {
        this.mDelegate = delegate;
    }

    @NonNull
    public SupportSQLiteStatement compileStatement(@NonNull String sql) {
        return new FrameworkSQLiteStatement(this.mDelegate.compileStatement(sql));
    }

    public void beginTransaction() {
        this.mDelegate.beginTransaction();
    }

    public void beginTransactionNonExclusive() {
        this.mDelegate.beginTransactionNonExclusive();
    }

    public void beginTransactionWithListener(@NonNull SQLiteTransactionListener transactionListener) {
        this.mDelegate.beginTransactionWithListener(transactionListener);
    }

    public void beginTransactionWithListenerNonExclusive(@NonNull SQLiteTransactionListener transactionListener) {
        this.mDelegate.beginTransactionWithListenerNonExclusive(transactionListener);
    }

    public void endTransaction() {
        this.mDelegate.endTransaction();
    }

    public void setTransactionSuccessful() {
        this.mDelegate.setTransactionSuccessful();
    }

    public boolean inTransaction() {
        return this.mDelegate.inTransaction();
    }

    public boolean isDbLockedByCurrentThread() {
        return this.mDelegate.isDbLockedByCurrentThread();
    }

    public boolean yieldIfContendedSafely() {
        return this.mDelegate.yieldIfContendedSafely();
    }

    public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
        return this.mDelegate.yieldIfContendedSafely(sleepAfterYieldDelay);
    }

    public boolean isExecPerConnectionSQLSupported() {
        return Build.VERSION.SDK_INT >= 30;
    }

    public void execPerConnectionSQL(@NonNull String sql, @Nullable Object[] bindArgs) {
        if (Build.VERSION.SDK_INT < 30) {
            throw new UnsupportedOperationException("execPerConnectionSQL is not supported on a SDK version lower than 30, current version is: " + Build.VERSION.SDK_INT);
        }
        Api30Impl.execPerConnectionSQL(this.mDelegate, sql, bindArgs);
    }

    public int getVersion() {
        return this.mDelegate.getVersion();
    }

    public void setVersion(int version) {
        this.mDelegate.setVersion(version);
    }

    public long getMaximumSize() {
        return this.mDelegate.getMaximumSize();
    }

    public long setMaximumSize(long numBytes) {
        return this.mDelegate.setMaximumSize(numBytes);
    }

    public long getPageSize() {
        return this.mDelegate.getPageSize();
    }

    public void setPageSize(long numBytes) {
        this.mDelegate.setPageSize(numBytes);
    }

    @NonNull
    public Cursor query(@NonNull String query) {
        return this.query((SupportSQLiteQuery)new SimpleSQLiteQuery(query));
    }

    @NonNull
    public Cursor query(@NonNull String query, @NonNull Object[] bindArgs) {
        return this.query((SupportSQLiteQuery)new SimpleSQLiteQuery(query, bindArgs));
    }

    @NonNull
    public Cursor query(@NonNull SupportSQLiteQuery supportQuery) {
        return this.mDelegate.rawQueryWithFactory((db, masterQuery, editTable, query) -> {
            supportQuery.bindTo((SupportSQLiteProgram)new FrameworkSQLiteProgram((SQLiteProgram)query));
            return new SQLiteCursor(masterQuery, editTable, query);
        }, supportQuery.getSql(), EMPTY_STRING_ARRAY, null);
    }

    @RequiresApi(value=16)
    @NonNull
    public Cursor query(@NonNull SupportSQLiteQuery supportQuery, CancellationSignal cancellationSignal) {
        return SupportSQLiteCompat.Api16Impl.rawQueryWithFactory((SQLiteDatabase)this.mDelegate, (String)supportQuery.getSql(), (String[])EMPTY_STRING_ARRAY, null, (CancellationSignal)cancellationSignal, (db, masterQuery, editTable, query) -> {
            supportQuery.bindTo((SupportSQLiteProgram)new FrameworkSQLiteProgram((SQLiteProgram)query));
            return new SQLiteCursor(masterQuery, editTable, query);
        });
    }

    public long insert(@NonNull String table, int conflictAlgorithm, @NonNull ContentValues values) throws SQLException {
        return this.mDelegate.insertWithOnConflict(table, null, values, conflictAlgorithm);
    }

    public int delete(@NonNull String table, String whereClause, Object[] whereArgs) {
        String query = "DELETE FROM " + table + (TextUtils.isEmpty((CharSequence)whereClause) ? "" : " WHERE " + whereClause);
        SupportSQLiteStatement statement = this.compileStatement(query);
        SimpleSQLiteQuery.bind((SupportSQLiteProgram)statement, (Object[])whereArgs);
        return statement.executeUpdateDelete();
    }

    public int update(@NonNull String table, int conflictAlgorithm, ContentValues values, String whereClause, Object[] whereArgs) {
        if (values == null || values.size() == 0) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(CONFLICT_VALUES[conflictAlgorithm]);
        sql.append(table);
        sql.append(" SET ");
        int setValuesSize = values.size();
        int bindArgsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        Object[] bindArgs = new Object[bindArgsSize];
        int i = 0;
        for (String colName : values.keySet()) {
            sql.append(i > 0 ? "," : "");
            sql.append(colName);
            bindArgs[i++] = values.get(colName);
            sql.append("=?");
        }
        if (whereArgs != null) {
            for (i = setValuesSize; i < bindArgsSize; ++i) {
                bindArgs[i] = whereArgs[i - setValuesSize];
            }
        }
        if (!TextUtils.isEmpty((CharSequence)whereClause)) {
            sql.append(" WHERE ");
            sql.append(whereClause);
        }
        SupportSQLiteStatement stmt = this.compileStatement(sql.toString());
        SimpleSQLiteQuery.bind((SupportSQLiteProgram)stmt, (Object[])bindArgs);
        return stmt.executeUpdateDelete();
    }

    public void execSQL(@NonNull String sql) throws SQLException {
        this.mDelegate.execSQL(sql);
    }

    public void execSQL(@NonNull String sql, Object[] bindArgs) throws SQLException {
        this.mDelegate.execSQL(sql, bindArgs);
    }

    public boolean isReadOnly() {
        return this.mDelegate.isReadOnly();
    }

    public boolean isOpen() {
        return this.mDelegate.isOpen();
    }

    public boolean needUpgrade(int newVersion) {
        return this.mDelegate.needUpgrade(newVersion);
    }

    public String getPath() {
        return this.mDelegate.getPath();
    }

    public void setLocale(@NonNull Locale locale) {
        this.mDelegate.setLocale(locale);
    }

    public void setMaxSqlCacheSize(int cacheSize) {
        this.mDelegate.setMaxSqlCacheSize(cacheSize);
    }

    @RequiresApi(api=16)
    public void setForeignKeyConstraintsEnabled(boolean enable) {
        SupportSQLiteCompat.Api16Impl.setForeignKeyConstraintsEnabled((SQLiteDatabase)this.mDelegate, (boolean)enable);
    }

    public boolean enableWriteAheadLogging() {
        return this.mDelegate.enableWriteAheadLogging();
    }

    @RequiresApi(api=16)
    public void disableWriteAheadLogging() {
        SupportSQLiteCompat.Api16Impl.disableWriteAheadLogging((SQLiteDatabase)this.mDelegate);
    }

    @RequiresApi(api=16)
    public boolean isWriteAheadLoggingEnabled() {
        return SupportSQLiteCompat.Api16Impl.isWriteAheadLoggingEnabled((SQLiteDatabase)this.mDelegate);
    }

    public List<Pair<String, String>> getAttachedDbs() {
        return this.mDelegate.getAttachedDbs();
    }

    public boolean isDatabaseIntegrityOk() {
        return this.mDelegate.isDatabaseIntegrityOk();
    }

    public void close() throws IOException {
        this.mDelegate.close();
    }

    boolean isDelegate(SQLiteDatabase sqLiteDatabase) {
        return this.mDelegate == sqLiteDatabase;
    }

    @RequiresApi(value=30)
    static class Api30Impl {
        private Api30Impl() {
        }

        @DoNotInline
        static void execPerConnectionSQL(SQLiteDatabase sQLiteDatabase, String sql, Object[] bindArgs) {
            sQLiteDatabase.execPerConnectionSQL(sql, bindArgs);
        }
    }
}

