/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.room.util.CursorUtil;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class DBUtil {
    @NonNull
    public static Cursor query(RoomDatabase db, SupportSQLiteQuery sqLiteQuery, boolean maybeCopy) {
        Cursor cursor = db.query(sqLiteQuery);
        if (maybeCopy && cursor instanceof AbstractWindowedCursor) {
            AbstractWindowedCursor windowedCursor = (AbstractWindowedCursor)cursor;
            int rowsInCursor = windowedCursor.getCount();
            int rowsInWindow = windowedCursor.hasWindow() ? windowedCursor.getWindow().getNumRows() : rowsInCursor;
            if (Build.VERSION.SDK_INT < 23 || rowsInWindow < rowsInCursor) {
                return CursorUtil.copyAndClose((Cursor)windowedCursor);
            }
        }
        return cursor;
    }

    public static void dropFtsSyncTriggers(SupportSQLiteDatabase db) {
        ArrayList<String> existingTriggers = new ArrayList<String>();
        try (Cursor cursor = db.query("SELECT name FROM sqlite_master WHERE type = 'trigger'");){
            while (cursor.moveToNext()) {
                existingTriggers.add(cursor.getString(0));
            }
        }
        for (String triggerName : existingTriggers) {
            if (!triggerName.startsWith("room_fts_content_sync_")) continue;
            db.execSQL("DROP TRIGGER IF EXISTS " + triggerName);
        }
    }

    private DBUtil() {
    }
}

