/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomMasterTable;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class RoomOpenHelper
extends SupportSQLiteOpenHelper.Callback {
    @Nullable
    private DatabaseConfiguration mConfiguration;
    @NonNull
    private final Delegate mDelegate;
    @NonNull
    private final String mIdentityHash;
    @NonNull
    private final String mLegacyHash;

    public RoomOpenHelper(@NonNull DatabaseConfiguration configuration, @NonNull Delegate delegate, @NonNull String identityHash, @NonNull String legacyHash) {
        super(delegate.version);
        this.mConfiguration = configuration;
        this.mDelegate = delegate;
        this.mIdentityHash = identityHash;
        this.mLegacyHash = legacyHash;
    }

    public RoomOpenHelper(@NonNull DatabaseConfiguration configuration, @NonNull Delegate delegate, @NonNull String legacyHash) {
        this(configuration, delegate, "", legacyHash);
    }

    public void onConfigure(SupportSQLiteDatabase db) {
        super.onConfigure(db);
    }

    public void onCreate(SupportSQLiteDatabase db) {
        this.updateIdentity(db);
        this.mDelegate.createAllTables(db);
        this.mDelegate.onCreate(db);
    }

    public void onUpgrade(SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        List<Migration> migrations;
        boolean migrated = false;
        if (this.mConfiguration != null && (migrations = this.mConfiguration.migrationContainer.findMigrationPath(oldVersion, newVersion)) != null) {
            this.mDelegate.onPreMigrate(db);
            for (Migration migration : migrations) {
                migration.migrate(db);
            }
            this.mDelegate.validateMigration(db);
            this.mDelegate.onPostMigrate(db);
            this.updateIdentity(db);
            migrated = true;
        }
        if (!migrated) {
            if (this.mConfiguration != null && !this.mConfiguration.isMigrationRequired(oldVersion, newVersion)) {
                this.mDelegate.dropAllTables(db);
                this.mDelegate.createAllTables(db);
            } else {
                throw new IllegalStateException("A migration from " + oldVersion + " to " + newVersion + " was required but not found. Please provide the necessary Migration path via RoomDatabase.Builder.addMigration(Migration ...) or allow for destructive migrations via one of the RoomDatabase.Builder.fallbackToDestructiveMigration* methods.");
            }
        }
    }

    public void onDowngrade(SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    public void onOpen(SupportSQLiteDatabase db) {
        super.onOpen(db);
        this.checkIdentity(db);
        this.mDelegate.onOpen(db);
        this.mConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIdentity(SupportSQLiteDatabase db) {
        String identityHash = null;
        if (RoomOpenHelper.hasRoomMasterTable(db)) {
            try (Cursor cursor = db.query((SupportSQLiteQuery)new SimpleSQLiteQuery("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1"));){
                if (cursor.moveToFirst()) {
                    identityHash = cursor.getString(0);
                }
            }
        }
        if (!this.mIdentityHash.equals(identityHash) && !this.mLegacyHash.equals(identityHash)) {
            throw new IllegalStateException("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number.");
        }
    }

    private void updateIdentity(SupportSQLiteDatabase db) {
        this.createMasterTableIfNotExists(db);
        db.execSQL(RoomMasterTable.createInsertQuery((String)this.mIdentityHash));
    }

    private void createMasterTableIfNotExists(SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    private static boolean hasRoomMasterTable(SupportSQLiteDatabase db) {
        try (Cursor cursor = db.query("SELECT 1 FROM sqlite_master WHERE type = 'table' AND name='room_master_table'");){
            boolean bl = cursor.moveToFirst() && cursor.getInt(0) != 0;
            return bl;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static abstract class Delegate {
        public final int version;

        public Delegate(int version) {
            this.version = version;
        }

        protected abstract void dropAllTables(SupportSQLiteDatabase var1);

        protected abstract void createAllTables(SupportSQLiteDatabase var1);

        protected abstract void onOpen(SupportSQLiteDatabase var1);

        protected abstract void onCreate(SupportSQLiteDatabase var1);

        protected abstract void validateMigration(SupportSQLiteDatabase var1);

        protected void onPreMigrate(SupportSQLiteDatabase database) {
        }

        protected void onPostMigrate(SupportSQLiteDatabase database) {
        }
    }
}

