/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.IMultiInstanceInvalidationCallback;
import androidx.room.IMultiInstanceInvalidationService;
import androidx.room.InvalidationTracker;
import androidx.room.MultiInstanceInvalidationService;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

class MultiInstanceInvalidationClient {
    @Nullable
    Context mContext;
    final String mName;
    int mClientId;
    final InvalidationTracker mInvalidationTracker;
    final InvalidationTracker.Observer mObserver;
    @Nullable
    IMultiInstanceInvalidationService mService;
    final Executor mExecutor;
    final IMultiInstanceInvalidationCallback mCallback = new IMultiInstanceInvalidationCallback.Stub(){

        @Override
        public void onInvalidation(final String[] tables) {
            MultiInstanceInvalidationClient.this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MultiInstanceInvalidationClient.this.mInvalidationTracker.notifyObserversByTableNames(tables);
                }
            });
        }
    };
    final AtomicBoolean mStopped = new AtomicBoolean(false);
    final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            MultiInstanceInvalidationClient.this.mService = IMultiInstanceInvalidationService.Stub.asInterface(service);
            MultiInstanceInvalidationClient.this.mExecutor.execute(MultiInstanceInvalidationClient.this.mSetUpRunnable);
        }

        public void onServiceDisconnected(ComponentName name) {
            MultiInstanceInvalidationClient.this.mExecutor.execute(MultiInstanceInvalidationClient.this.mRemoveObserverRunnable);
            MultiInstanceInvalidationClient.this.mService = null;
            MultiInstanceInvalidationClient.this.mContext = null;
        }
    };
    final Runnable mSetUpRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                IMultiInstanceInvalidationService service = MultiInstanceInvalidationClient.this.mService;
                if (service != null) {
                    MultiInstanceInvalidationClient.this.mClientId = service.registerCallback(MultiInstanceInvalidationClient.this.mCallback, MultiInstanceInvalidationClient.this.mName);
                    MultiInstanceInvalidationClient.this.mInvalidationTracker.addObserver(MultiInstanceInvalidationClient.this.mObserver);
                }
            }
            catch (RemoteException e) {
                Log.w((String)"ROOM", (String)"Cannot register multi-instance invalidation callback", (Throwable)e);
            }
        }
    };
    final Runnable mRemoveObserverRunnable = new Runnable(){

        @Override
        public void run() {
            MultiInstanceInvalidationClient.this.mInvalidationTracker.removeObserver(MultiInstanceInvalidationClient.this.mObserver);
        }
    };
    private final Runnable mTearDownRunnable = new Runnable(){

        @Override
        public void run() {
            MultiInstanceInvalidationClient.this.mInvalidationTracker.removeObserver(MultiInstanceInvalidationClient.this.mObserver);
            try {
                IMultiInstanceInvalidationService service = MultiInstanceInvalidationClient.this.mService;
                if (service != null) {
                    service.unregisterCallback(MultiInstanceInvalidationClient.this.mCallback, MultiInstanceInvalidationClient.this.mClientId);
                }
            }
            catch (RemoteException e) {
                Log.w((String)"ROOM", (String)"Cannot unregister multi-instance invalidation callback", (Throwable)e);
            }
            if (MultiInstanceInvalidationClient.this.mContext != null) {
                MultiInstanceInvalidationClient.this.mContext.unbindService(MultiInstanceInvalidationClient.this.mServiceConnection);
                MultiInstanceInvalidationClient.this.mContext = null;
            }
        }
    };

    MultiInstanceInvalidationClient(Context context, String name, InvalidationTracker invalidationTracker, Executor executor) {
        this.mContext = context.getApplicationContext();
        this.mName = name;
        this.mInvalidationTracker = invalidationTracker;
        this.mExecutor = executor;
        this.mObserver = new InvalidationTracker.Observer(invalidationTracker.mTableNames){

            @Override
            public void onInvalidated(@NonNull Set<String> tables) {
                if (MultiInstanceInvalidationClient.this.mStopped.get()) {
                    return;
                }
                try {
                    MultiInstanceInvalidationClient.this.mService.broadcastInvalidation(MultiInstanceInvalidationClient.this.mClientId, tables.toArray(new String[0]));
                }
                catch (RemoteException e) {
                    Log.w((String)"ROOM", (String)"Cannot broadcast invalidation", (Throwable)e);
                }
            }

            @Override
            boolean isRemote() {
                return true;
            }
        };
        Intent intent = new Intent(this.mContext, MultiInstanceInvalidationService.class);
        this.mContext.bindService(intent, this.mServiceConnection, 1);
    }

    void stop() {
        if (this.mStopped.compareAndSet(false, true)) {
            this.mExecutor.execute(this.mTearDownRunnable);
        }
    }
}

