/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.DatabaseView;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.SqlParser;
import androidx.room.processor.Context;
import androidx.room.processor.EntityOrViewProcessor;
import androidx.room.processor.FieldProcessor;
import androidx.room.processor.PojoProcessor;
import androidx.room.processor.ProcessorErrors;
import androidx.room.vo.Pojo;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/room/processor/DatabaseViewProcessor;", "Landroidx/room/processor/EntityOrViewProcessor;", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Ljava/util/LinkedHashSet;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "process", "Landroidx/room/vo/DatabaseView;", "Companion", "room-compiler"})
public final class DatabaseViewProcessor
implements EntityOrViewProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final LinkedHashSet<String> referenceStack;
    @NotNull
    private final Context context;

    public DatabaseViewProcessor(@NotNull Context baseContext, @NotNull XTypeElement element, @NotNull LinkedHashSet<String> referenceStack) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
    }

    public /* synthetic */ DatabaseViewProcessor(Context context, XTypeElement xTypeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<String>();
        }
        this(context, xTypeElement, linkedHashSet);
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public androidx.room.vo.DatabaseView process() {
        ParsedQuery parsedQuery;
        String viewName;
        this.context.getChecker().hasAnnotation((XElement)this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(DatabaseView.class), ProcessorErrors.INSTANCE.getVIEW_MUST_BE_ANNOTATED_WITH_DATABASE_VIEW(), new Object[0]);
        XAnnotationBox annotationBox = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(DatabaseView.class));
        String string = viewName = annotationBox != null ? Companion.extractViewName(this.element, (DatabaseView)annotationBox.getValue()) : this.element.getName();
        if (annotationBox != null) {
            ParsedQuery parsedQuery2;
            ParsedQuery it = parsedQuery2 = SqlParser.Companion.parse(((DatabaseView)annotationBox.getValue()).value());
            boolean bl = false;
            this.getContext().getChecker().check(it.getErrors().isEmpty(), (XElement)this.getElement(), CollectionsKt.joinToString$default((Iterable)it.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), new Object[0]);
            this.getContext().getChecker().check(it.getType() == QueryType.SELECT, (XElement)this.getElement(), ProcessorErrors.INSTANCE.getVIEW_QUERY_MUST_BE_SELECT(), new Object[0]);
            this.getContext().getChecker().check(it.getBindSections().isEmpty(), (XElement)this.getElement(), ProcessorErrors.INSTANCE.getVIEW_QUERY_CANNOT_TAKE_ARGUMENTS(), new Object[0]);
            parsedQuery = parsedQuery2;
        } else {
            parsedQuery = ParsedQuery.Companion.getMISSING();
        }
        ParsedQuery query2 = parsedQuery;
        this.context.getChecker().notBlank(viewName, (XElement)this.element, ProcessorErrors.INSTANCE.getVIEW_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        this.context.getChecker().check(!StringsKt.startsWith((String)viewName, (String)"sqlite_", (boolean)true), (XElement)this.element, ProcessorErrors.INSTANCE.getVIEW_NAME_CANNOT_START_WITH_SQLITE(), new Object[0]);
        Pojo pojo = PojoProcessor.Companion.createFor(this.context, this.element, FieldProcessor.BindingScope.READ_FROM_CURSOR, null, this.referenceStack).process();
        return new androidx.room.vo.DatabaseView(this.element, viewName, query2, pojo.getType(), pojo.getFields(), pojo.getEmbeddedFields(), pojo.getConstructor());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/room/processor/DatabaseViewProcessor$Companion;", "", "()V", "extractViewName", "", "element", "Landroidx/room/compiler/processing/XTypeElement;", "annotation", "Landroidx/room/DatabaseView;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String extractViewName(@NotNull XTypeElement element, @NotNull DatabaseView annotation) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            return Intrinsics.areEqual((Object)annotation.viewName(), (Object)"") ? element.getName() : annotation.viewName();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

