/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.room.DatabaseProcessingStep;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XProcessingStep;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.SimpleJavaVersion;
import androidx.room.vo.Warning;
import com.google.auto.common.BasicAnnotationProcessor;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/room/RoomProcessor;", "Lcom/google/auto/common/BasicAnnotationProcessor;", "()V", "jdkVersionHasBugReported", "", "getSupportedOptions", "", "", "getSupportedSourceVersion", "Ljavax/lang/model/SourceVersion;", "methodParametersVisibleInClassFiles", "steps", "", "Lcom/google/auto/common/BasicAnnotationProcessor$Step;", "room-compiler"})
public final class RoomProcessor
extends BasicAnnotationProcessor {
    private boolean jdkVersionHasBugReported;

    @NotNull
    protected Iterable<BasicAnnotationProcessor.Step> steps() {
        Object[] objectArray = new BasicAnnotationProcessor.Step[1];
        XProcessingStep xProcessingStep = new DatabaseProcessingStep();
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
        objectArray[0] = XProcessingStep.Companion.asAutoCommonProcessor(xProcessingStep, processingEnvironment);
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public Set<String> getSupportedOptions() {
        Set supportedOptions = CollectionsKt.toMutableSet((Iterable)Context.Companion.getARG_OPTIONS());
        ProcessingEnvironment processingEnvironment = this.processingEnv;
        Intrinsics.checkNotNullExpressionValue((Object)processingEnvironment, (String)"processingEnv");
        XProcessingEnv xProcessing = XProcessingEnv.Companion.create(processingEnvironment);
        if (Context.BooleanProcessorOptions.INCREMENTAL.getValue(xProcessing)) {
            if (this.methodParametersVisibleInClassFiles()) {
                supportedOptions.add("org.gradle.annotation.processing.isolating");
            } else if (!this.jdkVersionHasBugReported) {
                new Context(xProcessing).getLogger().w(Warning.JDK_VERSION_HAS_BUG, ProcessorErrors.INSTANCE.getJDK_VERSION_HAS_BUG(), new Object[0]);
                this.jdkVersionHasBugReported = true;
            }
        }
        return supportedOptions;
    }

    private final boolean methodParametersVisibleInClassFiles() {
        boolean bl;
        boolean bl2;
        boolean isEmbeddedJdk;
        SimpleJavaVersion simpleJavaVersion = SimpleJavaVersion.Companion.getCurrentVersion();
        if (simpleJavaVersion == null) {
            return false;
        }
        SimpleJavaVersion currentJavaVersion = simpleJavaVersion;
        if (currentJavaVersion.compareTo(SimpleJavaVersion.Companion.getVERSION_11_0_0()) >= 0) {
            return true;
        }
        String string = System.getProperty("java.vendor");
        boolean bl3 = isEmbeddedJdk = string == null ? false : (bl2 = StringsKt.contains((CharSequence)string, (CharSequence)"JetBrains", (boolean)true));
        if (isEmbeddedJdk && currentJavaVersion.compareTo(SimpleJavaVersion.Companion.getVERSION_1_8_0_202()) > 0) {
            bl = true;
        } else if (isEmbeddedJdk && Intrinsics.areEqual((Object)currentJavaVersion, (Object)SimpleJavaVersion.Companion.getVERSION_1_8_0_202())) {
            string = System.getProperty("java.runtime.version");
            if (string == null) {
                bl = false;
            } else {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                bl = bl2 = !Intrinsics.areEqual((Object)it, (Object)"1.8.0_202-release-1483-b39-5396753");
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latest();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sourceVersion), (String)"latest()");
        return sourceVersion;
    }
}

