/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.DiffingChangePayload;
import androidx.paging.NullPaddedDiffResult;
import androidx.paging.NullPaddedList;
import androidx.recyclerview.widget.ListUpdateCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Landroidx/paging/OverlappingListsDiffDispatcher;", "", "()V", "dispatchDiff", "", "T", "oldList", "Landroidx/paging/NullPaddedList;", "newList", "callback", "Landroidx/recyclerview/widget/ListUpdateCallback;", "diffResult", "Landroidx/paging/NullPaddedDiffResult;", "PlaceholderUsingUpdateCallback", "paging-runtime_release"})
public final class OverlappingListsDiffDispatcher {
    @NotNull
    public static final OverlappingListsDiffDispatcher INSTANCE = new OverlappingListsDiffDispatcher();

    private OverlappingListsDiffDispatcher() {
    }

    public final <T> void dispatchDiff(@NotNull NullPaddedList<T> oldList, @NotNull NullPaddedList<T> newList, @NotNull ListUpdateCallback callback2, @NotNull NullPaddedDiffResult diffResult2) {
        Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
        Intrinsics.checkNotNullParameter(newList, (String)"newList");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)diffResult2, (String)"diffResult");
        PlaceholderUsingUpdateCallback<T> callbackWrapper = new PlaceholderUsingUpdateCallback<T>(oldList, newList, callback2);
        diffResult2.getDiff().dispatchUpdatesTo((ListUpdateCallback)callbackWrapper);
        callbackWrapper.fixPlaceholders();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\b\u0002\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\"\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\r\u0010!\u001a\u00020\t*\u00020\tH\u0082\bR\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/paging/OverlappingListsDiffDispatcher$PlaceholderUsingUpdateCallback;", "T", "Landroidx/recyclerview/widget/ListUpdateCallback;", "oldList", "Landroidx/paging/NullPaddedList;", "newList", "callback", "(Landroidx/paging/NullPaddedList;Landroidx/paging/NullPaddedList;Landroidx/recyclerview/widget/ListUpdateCallback;)V", "placeholdersAfter", "", "placeholdersAfterState", "placeholdersBefore", "placeholdersBeforeState", "storageCount", "dispatchInsertAsPlaceholderAfter", "", "position", "count", "dispatchInsertAsPlaceholderBefore", "dispatchRemovalAsPlaceholdersAfter", "dispatchRemovalAsPlaceholdersBefore", "fixLeadingPlaceholders", "", "fixPlaceholders", "fixTrailingPlaceholders", "onChanged", "payload", "", "onInserted", "onMoved", "fromPosition", "toPosition", "onRemoved", "offsetForDispatch", "Companion", "paging-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nNullPaddedListDiffHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullPaddedListDiffHelper.kt\nandroidx/paging/OverlappingListsDiffDispatcher$PlaceholderUsingUpdateCallback\n*L\n1#1,532:1\n211#1:533\n211#1:534\n211#1:535\n211#1:536\n211#1:537\n211#1:538\n211#1:539\n211#1:540\n211#1:541\n211#1:542\n211#1:543\n211#1:544\n*S KotlinDebug\n*F\n+ 1 NullPaddedListDiffHelper.kt\nandroidx/paging/OverlappingListsDiffDispatcher$PlaceholderUsingUpdateCallback\n*L\n294#1:533\n316#1:534\n323#1:535\n343#1:536\n350#1:537\n366#1:538\n391#1:539\n396#1:540\n427#1:541\n434#1:542\n440#1:543\n444#1:544\n*E\n"})
    private static final class PlaceholderUsingUpdateCallback<T>
    implements ListUpdateCallback {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final NullPaddedList<T> oldList;
        @NotNull
        private final NullPaddedList<T> newList;
        @NotNull
        private final ListUpdateCallback callback;
        private int placeholdersBefore;
        private int placeholdersAfter;
        private int storageCount;
        private int placeholdersBeforeState;
        private int placeholdersAfterState;
        private static final int UNUSED = 1;
        private static final int USED_FOR_REMOVAL = 2;
        private static final int USED_FOR_ADDITION = 3;

        public PlaceholderUsingUpdateCallback(@NotNull NullPaddedList<T> oldList, @NotNull NullPaddedList<T> newList, @NotNull ListUpdateCallback callback2) {
            Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
            Intrinsics.checkNotNullParameter(newList, (String)"newList");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            this.oldList = oldList;
            this.newList = newList;
            this.callback = callback2;
            this.placeholdersBefore = this.oldList.getPlaceholdersBefore();
            this.placeholdersAfter = this.oldList.getPlaceholdersAfter();
            this.storageCount = this.oldList.getStorageCount();
            this.placeholdersBeforeState = 1;
            this.placeholdersAfterState = 1;
        }

        private final int offsetForDispatch(int $this$offsetForDispatch) {
            boolean $i$f$offsetForDispatch = false;
            return $this$offsetForDispatch + this.placeholdersBefore;
        }

        public final void fixPlaceholders() {
            this.fixLeadingPlaceholders();
            this.fixTrailingPlaceholders();
        }

        private final void fixTrailingPlaceholders() {
            boolean unchangedPlaceholdersMoved;
            int unchangedPlaceholders = Math.min(this.oldList.getPlaceholdersAfter(), this.placeholdersAfter);
            int postPlaceholdersToAdd = this.newList.getPlaceholdersAfter() - this.placeholdersAfter;
            int runningListSize = this.placeholdersBefore + this.storageCount + this.placeholdersAfter;
            int unchangedPlaceholdersStartPos = runningListSize - unchangedPlaceholders;
            boolean bl = unchangedPlaceholdersMoved = unchangedPlaceholdersStartPos != this.oldList.getSize() - unchangedPlaceholders;
            if (postPlaceholdersToAdd > 0) {
                this.callback.onInserted(runningListSize, postPlaceholdersToAdd);
            } else if (postPlaceholdersToAdd < 0) {
                this.callback.onRemoved(runningListSize + postPlaceholdersToAdd, -postPlaceholdersToAdd);
                unchangedPlaceholders += postPlaceholdersToAdd;
            }
            if (unchangedPlaceholders > 0 && unchangedPlaceholdersMoved) {
                this.callback.onChanged(unchangedPlaceholdersStartPos, unchangedPlaceholders, (Object)DiffingChangePayload.PLACEHOLDER_POSITION_CHANGE);
            }
            this.placeholdersAfter = this.newList.getPlaceholdersAfter();
        }

        private final void fixLeadingPlaceholders() {
            int unchangedPlaceholders = Math.min(this.oldList.getPlaceholdersBefore(), this.placeholdersBefore);
            int prePlaceholdersToAdd = this.newList.getPlaceholdersBefore() - this.placeholdersBefore;
            if (prePlaceholdersToAdd > 0) {
                if (unchangedPlaceholders > 0) {
                    this.callback.onChanged(0, unchangedPlaceholders, (Object)DiffingChangePayload.PLACEHOLDER_POSITION_CHANGE);
                }
                this.callback.onInserted(0, prePlaceholdersToAdd);
            } else if (prePlaceholdersToAdd < 0) {
                this.callback.onRemoved(0, -prePlaceholdersToAdd);
                if (unchangedPlaceholders + prePlaceholdersToAdd > 0) {
                    this.callback.onChanged(0, unchangedPlaceholders + prePlaceholdersToAdd, (Object)DiffingChangePayload.PLACEHOLDER_POSITION_CHANGE);
                }
            }
            this.placeholdersBefore = this.newList.getPlaceholdersBefore();
        }

        /*
         * WARNING - void declaration
         */
        public void onInserted(int position, int count) {
            if (!this.dispatchInsertAsPlaceholderAfter(position, count) && !this.dispatchInsertAsPlaceholderBefore(position, count)) {
                void this_$iv;
                PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
                int $this$offsetForDispatch$iv = position;
                boolean $i$f$offsetForDispatch = false;
                this.callback.onInserted($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, count);
            }
            this.storageCount += count;
        }

        private final boolean dispatchInsertAsPlaceholderBefore(int position, int count) {
            int asInsert;
            PlaceholderUsingUpdateCallback this_$iv;
            boolean $i$f$offsetForDispatch;
            int $this$offsetForDispatch$iv;
            if (position > 0) {
                return false;
            }
            if (this.placeholdersBeforeState == 2) {
                return false;
            }
            int asPlaceholderChange = Math.min(count, this.placeholdersBefore);
            if (asPlaceholderChange > 0) {
                this.placeholdersBeforeState = 3;
                int index = 0 - asPlaceholderChange;
                PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
                $this$offsetForDispatch$iv = index;
                $i$f$offsetForDispatch = false;
                this.callback.onChanged($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, asPlaceholderChange, (Object)DiffingChangePayload.PLACEHOLDER_TO_ITEM);
                this.placeholdersBefore -= asPlaceholderChange;
            }
            if ((asInsert = count - asPlaceholderChange) > 0) {
                this_$iv = this;
                $this$offsetForDispatch$iv = 0;
                $i$f$offsetForDispatch = false;
                this.callback.onInserted($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, asInsert);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean dispatchInsertAsPlaceholderAfter(int position, int count) {
            int asInsert;
            if (position < this.storageCount) {
                return false;
            }
            if (this.placeholdersAfterState == 2) {
                return false;
            }
            int asPlaceholderChange = Math.min(count, this.placeholdersAfter);
            if (asPlaceholderChange > 0) {
                void this_$iv;
                this.placeholdersAfterState = 3;
                PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
                int $this$offsetForDispatch$iv = position;
                boolean $i$f$offsetForDispatch = false;
                this.callback.onChanged($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, asPlaceholderChange, (Object)DiffingChangePayload.PLACEHOLDER_TO_ITEM);
                this.placeholdersAfter -= asPlaceholderChange;
            }
            if ((asInsert = count - asPlaceholderChange) > 0) {
                void this_$iv;
                PlaceholderUsingUpdateCallback $this$offsetForDispatch$iv = this;
                int $this$offsetForDispatch$iv2 = position + asPlaceholderChange;
                boolean $i$f$offsetForDispatch = false;
                this.callback.onInserted($this$offsetForDispatch$iv2 + this_$iv.placeholdersBefore, asInsert);
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void onRemoved(int position, int count) {
            if (!this.dispatchRemovalAsPlaceholdersAfter(position, count) && !this.dispatchRemovalAsPlaceholdersBefore(position, count)) {
                void this_$iv;
                PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
                int $this$offsetForDispatch$iv = position;
                boolean $i$f$offsetForDispatch = false;
                this.callback.onRemoved($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, count);
            }
            this.storageCount -= count;
        }

        private final boolean dispatchRemovalAsPlaceholdersBefore(int position, int count) {
            PlaceholderUsingUpdateCallback this_$iv;
            boolean $i$f$offsetForDispatch;
            int $this$offsetForDispatch$iv;
            if (position > 0) {
                return false;
            }
            if (this.placeholdersBeforeState == 3) {
                return false;
            }
            int maxPlaceholdersToAdd = this.newList.getPlaceholdersBefore() - this.placeholdersBefore;
            int asPlaceholders = RangesKt.coerceAtLeast((int)Math.min(maxPlaceholdersToAdd, count), (int)0);
            int asRemoval = count - asPlaceholders;
            if (asRemoval > 0) {
                PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
                $this$offsetForDispatch$iv = 0;
                $i$f$offsetForDispatch = false;
                this.callback.onRemoved($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, asRemoval);
            }
            if (asPlaceholders > 0) {
                this.placeholdersBeforeState = 2;
                this_$iv = this;
                $this$offsetForDispatch$iv = 0;
                $i$f$offsetForDispatch = false;
                this.callback.onChanged($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, asPlaceholders, (Object)DiffingChangePayload.ITEM_TO_PLACEHOLDER);
                this.placeholdersBefore += asPlaceholders;
            }
            return true;
        }

        private final boolean dispatchRemovalAsPlaceholdersAfter(int position, int count) {
            PlaceholderUsingUpdateCallback this_$iv;
            boolean $i$f$offsetForDispatch;
            int $this$offsetForDispatch$iv;
            int end = position + count;
            if (end < this.storageCount) {
                return false;
            }
            if (this.placeholdersAfterState == 3) {
                return false;
            }
            int maxPlaceholdersToAdd = this.newList.getPlaceholdersAfter() - this.placeholdersAfter;
            int asPlaceholders = RangesKt.coerceAtLeast((int)Math.min(maxPlaceholdersToAdd, count), (int)0);
            int asRemoval = count - asPlaceholders;
            if (asPlaceholders > 0) {
                this.placeholdersAfterState = 2;
                PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
                $this$offsetForDispatch$iv = position;
                $i$f$offsetForDispatch = false;
                this.callback.onChanged($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, asPlaceholders, (Object)DiffingChangePayload.ITEM_TO_PLACEHOLDER);
                this.placeholdersAfter += asPlaceholders;
            }
            if (asRemoval > 0) {
                this_$iv = this;
                $this$offsetForDispatch$iv = position + asPlaceholders;
                $i$f$offsetForDispatch = false;
                this.callback.onRemoved($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, asRemoval);
            }
            return true;
        }

        public void onMoved(int fromPosition, int toPosition) {
            PlaceholderUsingUpdateCallback this_$iv;
            PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
            int $this$offsetForDispatch$iv = fromPosition;
            boolean $i$f$offsetForDispatch = false;
            int n = $this$offsetForDispatch$iv + this_$iv.placeholdersBefore;
            this_$iv = this;
            $this$offsetForDispatch$iv = toPosition;
            $i$f$offsetForDispatch = false;
            this.callback.onMoved(n, $this$offsetForDispatch$iv + this_$iv.placeholdersBefore);
        }

        /*
         * WARNING - void declaration
         */
        public void onChanged(int position, int count, @Nullable Object payload) {
            void this_$iv;
            PlaceholderUsingUpdateCallback placeholderUsingUpdateCallback = this;
            int $this$offsetForDispatch$iv = position;
            boolean $i$f$offsetForDispatch = false;
            this.callback.onChanged($this$offsetForDispatch$iv + this_$iv.placeholdersBefore, count, payload);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/paging/OverlappingListsDiffDispatcher$PlaceholderUsingUpdateCallback$Companion;", "", "()V", "UNUSED", "", "USED_FOR_ADDITION", "USED_FOR_REMOVAL", "paging-runtime_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

