/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.DiffingChangePayload;
import androidx.paging.NullPaddedList;
import androidx.recyclerview.widget.ListUpdateCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0001H\u0002J4\u0010\r\u001a\u00020\u0004\"\b\b\u0000\u0010\u000e*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a8\u0006\u0012"}, d2={"Landroidx/paging/DistinctListsDiffDispatcher;", "", "()V", "dispatchChange", "", "callback", "Landroidx/recyclerview/widget/ListUpdateCallback;", "startBoundary", "", "endBoundary", "start", "end", "payload", "dispatchDiff", "T", "oldList", "Landroidx/paging/NullPaddedList;", "newList", "paging-runtime_release"})
public final class DistinctListsDiffDispatcher {
    @NotNull
    public static final DistinctListsDiffDispatcher INSTANCE = new DistinctListsDiffDispatcher();

    private DistinctListsDiffDispatcher() {
    }

    public final <T> void dispatchDiff(@NotNull ListUpdateCallback callback2, @NotNull NullPaddedList<T> oldList, @NotNull NullPaddedList<T> newList) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
        Intrinsics.checkNotNullParameter(newList, (String)"newList");
        int storageOverlapStart = Math.max(oldList.getPlaceholdersBefore(), newList.getPlaceholdersBefore());
        int storageOverlapEnd = Math.min(oldList.getPlaceholdersBefore() + oldList.getStorageCount(), newList.getPlaceholdersBefore() + newList.getStorageCount());
        int overlappingStorageSize = storageOverlapEnd - storageOverlapStart;
        if (overlappingStorageSize > 0) {
            callback2.onRemoved(storageOverlapStart, overlappingStorageSize);
            callback2.onInserted(storageOverlapStart, overlappingStorageSize);
        }
        int changeEventStartBoundary = Math.min(storageOverlapStart, storageOverlapEnd);
        int changeEventEndBoundary = Math.max(storageOverlapStart, storageOverlapEnd);
        this.dispatchChange(callback2, changeEventStartBoundary, changeEventEndBoundary, RangesKt.coerceAtMost((int)oldList.getPlaceholdersBefore(), (int)newList.getSize()), RangesKt.coerceAtMost((int)(oldList.getPlaceholdersBefore() + oldList.getStorageCount()), (int)newList.getSize()), DiffingChangePayload.ITEM_TO_PLACEHOLDER);
        this.dispatchChange(callback2, changeEventStartBoundary, changeEventEndBoundary, RangesKt.coerceAtMost((int)newList.getPlaceholdersBefore(), (int)oldList.getSize()), RangesKt.coerceAtMost((int)(newList.getPlaceholdersBefore() + newList.getStorageCount()), (int)oldList.getSize()), DiffingChangePayload.PLACEHOLDER_TO_ITEM);
        int itemsToAdd = newList.getSize() - oldList.getSize();
        if (itemsToAdd > 0) {
            callback2.onInserted(oldList.getSize(), itemsToAdd);
        } else if (itemsToAdd < 0) {
            callback2.onRemoved(oldList.getSize() + itemsToAdd, -itemsToAdd);
        }
    }

    private final void dispatchChange(ListUpdateCallback callback2, int startBoundary, int endBoundary, int start, int end, Object payload) {
        int afterOverlapCount;
        int beforeOverlapCount = startBoundary - start;
        if (beforeOverlapCount > 0) {
            callback2.onChanged(start, beforeOverlapCount, payload);
        }
        if ((afterOverlapCount = end - endBoundary) > 0) {
            callback2.onChanged(endBoundary, afterOverlapCount, payload);
        }
    }
}

