/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ts;

import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.TimestampAdjuster;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.ts.SectionPayloadReader;
import androidx.media3.extractor.ts.TsPayloadReader;

@UnstableApi
public final class SectionReader
implements TsPayloadReader {
    private static final int SECTION_HEADER_LENGTH = 3;
    private static final int DEFAULT_SECTION_BUFFER_LENGTH = 32;
    private static final int MAX_SECTION_LENGTH = 4098;
    private final SectionPayloadReader reader;
    private final ParsableByteArray sectionData;
    private int totalSectionLength;
    private int bytesRead;
    private boolean sectionSyntaxIndicator;
    private boolean waitingForPayloadStart;

    public SectionReader(SectionPayloadReader reader) {
        this.reader = reader;
        this.sectionData = new ParsableByteArray(32);
    }

    @Override
    public void init(TimestampAdjuster timestampAdjuster, ExtractorOutput extractorOutput, TsPayloadReader.TrackIdGenerator idGenerator) {
        this.reader.init(timestampAdjuster, extractorOutput, idGenerator);
        this.waitingForPayloadStart = true;
    }

    @Override
    public void seek() {
        this.waitingForPayloadStart = true;
    }

    @Override
    public void consume(ParsableByteArray data, int flags) {
        boolean payloadUnitStartIndicator = (flags & 1) != 0;
        int payloadStartPosition = -1;
        if (payloadUnitStartIndicator) {
            int payloadStartOffset = data.readUnsignedByte();
            payloadStartPosition = data.getPosition() + payloadStartOffset;
        }
        if (this.waitingForPayloadStart) {
            if (!payloadUnitStartIndicator) {
                return;
            }
            this.waitingForPayloadStart = false;
            data.setPosition(payloadStartPosition);
            this.bytesRead = 0;
        }
        while (data.bytesLeft() > 0) {
            if (this.bytesRead < 3) {
                if (this.bytesRead == 0) {
                    int tableId = data.readUnsignedByte();
                    data.setPosition(data.getPosition() - 1);
                    if (tableId == 255) {
                        this.waitingForPayloadStart = true;
                        return;
                    }
                }
                int headerBytesToRead = Math.min(data.bytesLeft(), 3 - this.bytesRead);
                data.readBytes(this.sectionData.getData(), this.bytesRead, headerBytesToRead);
                this.bytesRead += headerBytesToRead;
                if (this.bytesRead != 3) continue;
                this.sectionData.setPosition(0);
                this.sectionData.setLimit(3);
                this.sectionData.skipBytes(1);
                int secondHeaderByte = this.sectionData.readUnsignedByte();
                int thirdHeaderByte = this.sectionData.readUnsignedByte();
                this.sectionSyntaxIndicator = (secondHeaderByte & 0x80) != 0;
                this.totalSectionLength = ((secondHeaderByte & 0xF) << 8 | thirdHeaderByte) + 3;
                if (this.sectionData.capacity() >= this.totalSectionLength) continue;
                int limit = Math.min(4098, Math.max(this.totalSectionLength, this.sectionData.capacity() * 2));
                this.sectionData.ensureCapacity(limit);
                continue;
            }
            int bodyBytesToRead = Math.min(data.bytesLeft(), this.totalSectionLength - this.bytesRead);
            data.readBytes(this.sectionData.getData(), this.bytesRead, bodyBytesToRead);
            this.bytesRead += bodyBytesToRead;
            if (this.bytesRead != this.totalSectionLength) continue;
            if (this.sectionSyntaxIndicator) {
                if (Util.crc32((byte[])this.sectionData.getData(), (int)0, (int)this.totalSectionLength, (int)-1) != 0) {
                    this.waitingForPayloadStart = true;
                    return;
                }
                this.sectionData.setLimit(this.totalSectionLength - 4);
            } else {
                this.sectionData.setLimit(this.totalSectionLength);
            }
            this.sectionData.setPosition(0);
            this.reader.consume(this.sectionData);
            this.bytesRead = 0;
        }
    }
}

