/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.media3.common.Format;
import androidx.media3.common.util.Consumer;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.text.CuesWithTiming;
import androidx.media3.extractor.text.CuesWithTimingSubtitle;
import androidx.media3.extractor.text.Subtitle;
import com.google.common.collect.ImmutableList;
import java.util.List;

@UnstableApi
public interface SubtitleParser {
    default public void parse(byte[] data, OutputOptions outputOptions, Consumer<CuesWithTiming> output) {
        this.parse(data, 0, data.length, outputOptions, output);
    }

    public void parse(byte[] var1, int var2, int var3, OutputOptions var4, Consumer<CuesWithTiming> var5);

    default public Subtitle parseToLegacySubtitle(byte[] data, int offset, int length) {
        ImmutableList.Builder cuesWithTimingList = ImmutableList.builder();
        this.parse(data, offset, length, OutputOptions.ALL, (Consumer<CuesWithTiming>)((Consumer)arg_0 -> ((ImmutableList.Builder)cuesWithTimingList).add(arg_0)));
        return new CuesWithTimingSubtitle((List<CuesWithTiming>)cuesWithTimingList.build());
    }

    default public void reset() {
    }

    public int getCueReplacementBehavior();

    public static class OutputOptions {
        private static final OutputOptions ALL = new OutputOptions(-9223372036854775807L, false);
        public final long startTimeUs;
        public final boolean outputAllCues;

        private OutputOptions(long startTimeUs, boolean outputAllCues) {
            this.startTimeUs = startTimeUs;
            this.outputAllCues = outputAllCues;
        }

        public static OutputOptions allCues() {
            return ALL;
        }

        public static OutputOptions onlyCuesAfter(long startTimeUs) {
            return new OutputOptions(startTimeUs, false);
        }

        public static OutputOptions cuesAfterThenRemainingCuesBefore(long startTimeUs) {
            return new OutputOptions(startTimeUs, true);
        }
    }

    public static interface Factory {
        public static final Factory UNSUPPORTED = new Factory(){

            @Override
            public boolean supportsFormat(Format format) {
                return false;
            }

            @Override
            public int getCueReplacementBehavior(Format format) {
                return 1;
            }

            @Override
            public SubtitleParser create(Format format) {
                throw new IllegalStateException("This SubtitleParser.Factory doesn't support any formats.");
            }
        };

        public boolean supportsFormat(Format var1);

        public int getCueReplacementBehavior(Format var1);

        public SubtitleParser create(Format var1);
    }
}

