/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.flv;

import androidx.media3.common.ParserException;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.extractor.TrackOutput;

abstract class TagPayloadReader {
    protected final TrackOutput output;

    protected TagPayloadReader(TrackOutput output) {
        this.output = output;
    }

    public abstract void seek();

    public final boolean consume(ParsableByteArray data, long timeUs) throws ParserException {
        return this.parseHeader(data) && this.parsePayload(data, timeUs);
    }

    protected abstract boolean parseHeader(ParsableByteArray var1) throws ParserException;

    protected abstract boolean parsePayload(ParsableByteArray var1, long var2) throws ParserException;

    public static final class UnsupportedFormatException
    extends ParserException {
        public UnsupportedFormatException(String msg) {
            super(msg, null, false, 1);
        }
    }
}

