/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.viewsintegration;

import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.EmojiCompat;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
final class EmojiInputFilter
implements InputFilter {
    private final TextView mTextView;
    private EmojiCompat.InitCallback mInitCallback;

    EmojiInputFilter(@NonNull TextView textView) {
        this.mTextView = textView;
    }

    public CharSequence filter(CharSequence source, int sourceStart, int sourceEnd, Spanned dest, int destStart, int destEnd) {
        if (this.mTextView.isInEditMode()) {
            return source;
        }
        switch (EmojiCompat.get().getLoadState()) {
            case 1: {
                CharSequence oldText;
                boolean process = true;
                if (destEnd == 0 && destStart == 0 && dest.length() == 0 && source == (oldText = this.mTextView.getText())) {
                    process = false;
                }
                if (process && source != null) {
                    CharSequence text = sourceStart == 0 && sourceEnd == source.length() ? source : source.subSequence(sourceStart, sourceEnd);
                    return EmojiCompat.get().process(text, 0, text.length());
                }
                return source;
            }
            case 0: 
            case 3: {
                EmojiCompat.get().registerInitCallback(this.getInitCallback());
                return source;
            }
        }
        return source;
    }

    private EmojiCompat.InitCallback getInitCallback() {
        if (this.mInitCallback == null) {
            this.mInitCallback = new InitCallbackImpl(this.mTextView, this);
        }
        return this.mInitCallback;
    }

    static void updateSelection(Spannable spannable, int start, int end) {
        if (start >= 0 && end >= 0) {
            Selection.setSelection((Spannable)spannable, (int)start, (int)end);
        } else if (start >= 0) {
            Selection.setSelection((Spannable)spannable, (int)start);
        } else if (end >= 0) {
            Selection.setSelection((Spannable)spannable, (int)end);
        }
    }

    @RequiresApi(value=19)
    private static class InitCallbackImpl
    extends EmojiCompat.InitCallback {
        private final Reference<TextView> mViewRef;
        private final Reference<EmojiInputFilter> mEmojiInputFilterReference;

        InitCallbackImpl(TextView textView, EmojiInputFilter emojiInputFilter) {
            this.mViewRef = new WeakReference<TextView>(textView);
            this.mEmojiInputFilterReference = new WeakReference<EmojiInputFilter>(emojiInputFilter);
        }

        public void onInitialized() {
            super.onInitialized();
            TextView textView = this.mViewRef.get();
            InputFilter myInputFilter = this.mEmojiInputFilterReference.get();
            if (!this.isInputFilterCurrentlyRegisteredOnTextView(textView, myInputFilter)) {
                return;
            }
            if (textView.isAttachedToWindow()) {
                CharSequence result;
                CharSequence originalText = textView.getText();
                if (originalText == (result = EmojiCompat.get().process(originalText))) {
                    return;
                }
                int selectionStart = Selection.getSelectionStart((CharSequence)result);
                int selectionEnd = Selection.getSelectionEnd((CharSequence)result);
                textView.setText(result);
                if (result instanceof Spannable) {
                    EmojiInputFilter.updateSelection((Spannable)result, selectionStart, selectionEnd);
                }
            }
        }

        private boolean isInputFilterCurrentlyRegisteredOnTextView(@Nullable TextView textView, @Nullable InputFilter myInputFilter) {
            if (myInputFilter == null || textView == null) {
                return false;
            }
            InputFilter[] currentFilters = textView.getFilters();
            if (currentFilters == null) {
                return false;
            }
            for (int i = 0; i < currentFilters.length; ++i) {
                if (currentFilters[i] != myInputFilter) continue;
                return true;
            }
            return false;
        }
    }
}

