/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\r"}, d2={"Landroid/databinding/tool/util/RelativizableFile;", "", "baseDir", "Ljava/io/File;", "file", "(Ljava/io/File;Ljava/io/File;)V", "absoluteFile", "getAbsoluteFile", "()Ljava/io/File;", "getBaseDir", "relativeFile", "getRelativeFile", "Companion", "databinding-compiler-common"})
@SourceDebugExtension(value={"SMAP\nRelativizableFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelativizableFile.kt\nandroid/databinding/tool/util/RelativizableFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class RelativizableFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File baseDir;
    @NotNull
    private final File absoluteFile;
    @Nullable
    private final File relativeFile;

    private RelativizableFile(File baseDir, File file) {
        this.baseDir = baseDir;
        if (this.baseDir != null) {
            if (!this.baseDir.isAbsolute()) {
                boolean $i$a$-check-RelativizableFile$42 = false;
                String $i$a$-check-RelativizableFile$42 = this.baseDir.getPath() + " is not an absolute path";
                throw new IllegalStateException($i$a$-check-RelativizableFile$42.toString());
            }
            if (!(!file.isAbsolute())) {
                boolean $i$a$-check-RelativizableFile$52 = false;
                String $i$a$-check-RelativizableFile$52 = file.getPath() + " is not a relative path";
                throw new IllegalStateException($i$a$-check-RelativizableFile$52.toString());
            }
            this.absoluteFile = new File(this.baseDir, file.getPath());
            this.relativeFile = file;
        } else {
            if (!file.isAbsolute()) {
                boolean bl = false;
                String string = file.getPath() + " is not an absolute path";
                throw new IllegalStateException(string.toString());
            }
            this.absoluteFile = file;
            this.relativeFile = null;
        }
    }

    @Nullable
    public final File getBaseDir() {
        return this.baseDir;
    }

    @NotNull
    public final File getAbsoluteFile() {
        return this.absoluteFile;
    }

    @Nullable
    public final File getRelativeFile() {
        return this.relativeFile;
    }

    @JvmStatic
    @NotNull
    public static final RelativizableFile fromRelativeFile(@NotNull File baseDir, @NotNull File relativeFile) {
        return Companion.fromRelativeFile(baseDir, relativeFile);
    }

    @JvmStatic
    @NotNull
    public static final RelativizableFile fromAbsoluteFile(@NotNull File absoluteFile, @Nullable File baseDir) {
        return Companion.fromAbsoluteFile(absoluteFile, baseDir);
    }

    public /* synthetic */ RelativizableFile(File baseDir, File file, DefaultConstructorMarker $constructor_marker) {
        this(baseDir, file);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Landroid/databinding/tool/util/RelativizableFile$Companion;", "", "()V", "fromAbsoluteFile", "Landroid/databinding/tool/util/RelativizableFile;", "absoluteFile", "Ljava/io/File;", "baseDir", "fromRelativeFile", "relativeFile", "databinding-compiler-common"})
    @SourceDebugExtension(value={"SMAP\nRelativizableFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelativizableFile.kt\nandroid/databinding/tool/util/RelativizableFile$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RelativizableFile fromRelativeFile(@NotNull File baseDir, @NotNull File relativeFile) {
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            Intrinsics.checkNotNullParameter((Object)relativeFile, (String)"relativeFile");
            return new RelativizableFile(baseDir, relativeFile, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final RelativizableFile fromAbsoluteFile(@NotNull File absoluteFile, @Nullable File baseDir) {
            RelativizableFile relativizableFile;
            Intrinsics.checkNotNullParameter((Object)absoluteFile, (String)"absoluteFile");
            if (!absoluteFile.isAbsolute()) {
                boolean $i$a$-check-RelativizableFile$Companion$fromAbsoluteFile$22 = false;
                String $i$a$-check-RelativizableFile$Companion$fromAbsoluteFile$22 = absoluteFile.getPath() + " is not an absolute path";
                throw new IllegalStateException($i$a$-check-RelativizableFile$Companion$fromAbsoluteFile$22.toString());
            }
            File file = baseDir;
            if (file != null) {
                File it = file;
                boolean bl = false;
                if (!it.isAbsolute()) {
                    boolean bl2 = false;
                    String string = it.getPath() + " is not an absolute path";
                    throw new IllegalStateException(string.toString());
                }
            }
            if (baseDir != null) {
                String string = absoluteFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"absoluteFile.absolutePath");
                String string2 = baseDir.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"baseDir.absolutePath");
                if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                    File file2 = baseDir.toPath().relativize(absoluteFile.toPath()).toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"baseDir.toPath().relativ\u2026teFile.toPath()).toFile()");
                    relativizableFile = this.fromRelativeFile(baseDir, file2);
                    return relativizableFile;
                }
            }
            relativizableFile = new RelativizableFile(null, absoluteFile, null);
            return relativizableFile;
        }

        public static /* synthetic */ RelativizableFile fromAbsoluteFile$default(Companion companion, File file, File file2, int n, Object object) {
            if ((n & 2) != 0) {
                file2 = null;
            }
            return companion.fromAbsoluteFile(file, file2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

