/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.GuidelineReference;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.RunGroup;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;
import java.util.HashSet;

public class DependencyGraph {
    private static final boolean USE_GROUPS = true;
    private ConstraintWidgetContainer container;
    private boolean mNeedBuildGraph = true;
    private boolean mNeedRedoMeasures = true;
    private ConstraintWidgetContainer mContainer;
    private ArrayList<WidgetRun> mRuns = new ArrayList();
    private ArrayList<RunGroup> runGroups = new ArrayList();
    private BasicMeasure.Measurer mMeasurer = null;
    private BasicMeasure.Measure mMeasure = new BasicMeasure.Measure();
    ArrayList<RunGroup> mGroups = new ArrayList();

    public DependencyGraph(ConstraintWidgetContainer container) {
        this.container = container;
        this.mContainer = container;
    }

    public void setMeasurer(BasicMeasure.Measurer measurer) {
        this.mMeasurer = measurer;
    }

    private int computeWrap(ConstraintWidgetContainer container, int orientation) {
        int count = this.mGroups.size();
        long wrapSize = 0L;
        for (int i = 0; i < count; ++i) {
            RunGroup run = this.mGroups.get(i);
            long size = run.computeWrapSize(container, orientation);
            wrapSize = Math.max(wrapSize, size);
        }
        return (int)wrapSize;
    }

    public void defineTerminalWidgets(ConstraintWidget.DimensionBehaviour horizontalBehavior, ConstraintWidget.DimensionBehaviour verticalBehavior) {
        if (this.mNeedBuildGraph) {
            this.buildGraph();
            boolean hasBarrier = false;
            for (ConstraintWidget widget : this.container.mChildren) {
                widget.isTerminalWidget[0] = true;
                widget.isTerminalWidget[1] = true;
                if (!(widget instanceof Barrier)) continue;
                hasBarrier = true;
            }
            if (!hasBarrier) {
                for (RunGroup group : this.mGroups) {
                    group.defineTerminalWidgets(horizontalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, verticalBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
        }
    }

    public boolean directMeasure(boolean optimizeWrap) {
        boolean avoid;
        optimizeWrap &= true;
        if (this.mNeedBuildGraph || this.mNeedRedoMeasures) {
            for (ConstraintWidget widget : this.container.mChildren) {
                widget.measured = false;
                widget.horizontalRun.reset();
                widget.verticalRun.reset();
            }
            this.container.measured = false;
            this.container.horizontalRun.reset();
            this.container.verticalRun.reset();
            this.mNeedRedoMeasures = false;
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.container.setX(0);
        this.container.setY(0);
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.container.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.container.getDimensionBehaviour(1);
        if (this.mNeedBuildGraph) {
            this.buildGraph();
        }
        int x1 = this.container.getX();
        int y1 = this.container.getY();
        this.container.horizontalRun.start.resolve(x1);
        this.container.verticalRun.start.resolve(y1);
        this.measureWidgets();
        if (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            if (optimizeWrap) {
                for (WidgetRun run : this.mRuns) {
                    if (run.supportsWrapComputation()) continue;
                    optimizeWrap = false;
                    break;
                }
            }
            if (optimizeWrap && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.container.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.container.setWidth(this.computeWrap(this.container, 0));
                this.container.horizontalRun.dimension.resolve(this.container.getWidth());
            }
            if (optimizeWrap && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.container.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.container.setHeight(this.computeWrap(this.container, 1));
                this.container.verticalRun.dimension.resolve(this.container.getHeight());
            }
        }
        boolean checkRoot = false;
        if (this.container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int x2 = x1 + this.container.getWidth();
            this.container.horizontalRun.end.resolve(x2);
            this.container.horizontalRun.dimension.resolve(x2 - x1);
            this.measureWidgets();
            if (this.container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int y2 = y1 + this.container.getHeight();
                this.container.verticalRun.end.resolve(y2);
                this.container.verticalRun.dimension.resolve(y2 - y1);
            }
            this.measureWidgets();
            checkRoot = true;
        }
        for (WidgetRun run : this.mRuns) {
            if (run.widget == this.container && !run.resolved) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        for (WidgetRun run : this.mRuns) {
            if (!checkRoot && run.widget == this.container) continue;
            if (!run.start.resolved) {
                allResolved = false;
                break;
            }
            if (!run.end.resolved && !(run instanceof GuidelineReference)) {
                allResolved = false;
                break;
            }
            if (run.dimension.resolved || run instanceof ChainRun || run instanceof GuidelineReference) continue;
            allResolved = false;
            break;
        }
        this.container.setHorizontalDimensionBehaviour(originalHorizontalDimension);
        this.container.setVerticalDimensionBehaviour(originalVerticalDimension);
        return allResolved;
    }

    public boolean directMeasureSetup(boolean optimizeWrap) {
        boolean avoid;
        if (this.mNeedBuildGraph) {
            for (ConstraintWidget widget : this.container.mChildren) {
                widget.measured = false;
                widget.horizontalRun.dimension.resolved = false;
                widget.horizontalRun.resolved = false;
                widget.horizontalRun.reset();
                widget.verticalRun.dimension.resolved = false;
                widget.verticalRun.resolved = false;
                widget.verticalRun.reset();
            }
            this.container.measured = false;
            this.container.horizontalRun.dimension.resolved = false;
            this.container.horizontalRun.resolved = false;
            this.container.horizontalRun.reset();
            this.container.verticalRun.dimension.resolved = false;
            this.container.verticalRun.resolved = false;
            this.container.verticalRun.reset();
            this.buildGraph();
        }
        if (avoid = this.basicMeasureWidgets(this.mContainer)) {
            return false;
        }
        this.container.setX(0);
        this.container.setY(0);
        this.container.horizontalRun.start.resolve(0);
        this.container.verticalRun.start.resolve(0);
        return true;
    }

    public boolean directMeasureWithOrientation(boolean optimizeWrap, int orientation) {
        ConstraintWidget.DimensionBehaviour originalHorizontalDimension = this.container.getDimensionBehaviour(0);
        ConstraintWidget.DimensionBehaviour originalVerticalDimension = this.container.getDimensionBehaviour(1);
        int x1 = this.container.getX();
        int y1 = this.container.getY();
        if ((optimizeWrap &= true) && (originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
            for (WidgetRun run : this.mRuns) {
                if (run.orientation != orientation || run.supportsWrapComputation()) continue;
                optimizeWrap = false;
                break;
            }
            if (orientation == 0) {
                if (optimizeWrap && originalHorizontalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                    this.container.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    this.container.setWidth(this.computeWrap(this.container, 0));
                    this.container.horizontalRun.dimension.resolve(this.container.getWidth());
                }
            } else if (optimizeWrap && originalVerticalDimension == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                this.container.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                this.container.setHeight(this.computeWrap(this.container, 1));
                this.container.verticalRun.dimension.resolve(this.container.getHeight());
            }
        }
        boolean checkRoot = false;
        if (orientation == 0) {
            if (this.container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || this.container.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                int x2 = x1 + this.container.getWidth();
                this.container.horizontalRun.end.resolve(x2);
                this.container.horizontalRun.dimension.resolve(x2 - x1);
                checkRoot = true;
            }
        } else if (this.container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || this.container.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
            int y2 = y1 + this.container.getHeight();
            this.container.verticalRun.end.resolve(y2);
            this.container.verticalRun.dimension.resolve(y2 - y1);
            checkRoot = true;
        }
        this.measureWidgets();
        for (WidgetRun run : this.mRuns) {
            if (run.orientation != orientation || run.widget == this.container && !run.resolved) continue;
            run.applyToWidget();
        }
        boolean allResolved = true;
        for (WidgetRun run : this.mRuns) {
            if (run.orientation != orientation || !checkRoot && run.widget == this.container) continue;
            if (!run.start.resolved) {
                allResolved = false;
                break;
            }
            if (!run.end.resolved) {
                allResolved = false;
                break;
            }
            if (run instanceof ChainRun || run.dimension.resolved) continue;
            allResolved = false;
            break;
        }
        this.container.setHorizontalDimensionBehaviour(originalHorizontalDimension);
        this.container.setVerticalDimensionBehaviour(originalVerticalDimension);
        return allResolved;
    }

    private void measure(ConstraintWidget widget, ConstraintWidget.DimensionBehaviour horizontalBehavior, int horizontalDimension, ConstraintWidget.DimensionBehaviour verticalBehavior, int verticalDimension) {
        this.mMeasure.horizontalBehavior = horizontalBehavior;
        this.mMeasure.verticalBehavior = verticalBehavior;
        this.mMeasure.horizontalDimension = horizontalDimension;
        this.mMeasure.verticalDimension = verticalDimension;
        this.mMeasurer.measure(widget, this.mMeasure);
        widget.setWidth(this.mMeasure.measuredWidth);
        widget.setHeight(this.mMeasure.measuredHeight);
        widget.setHasBaseline(this.mMeasure.measuredHasBaseline);
        widget.setBaselineDistance(this.mMeasure.measuredBaseline);
    }

    private boolean basicMeasureWidgets(ConstraintWidgetContainer constraintWidgetContainer) {
        for (ConstraintWidget widget : constraintWidgetContainer.mChildren) {
            int height;
            ConstraintWidget.DimensionBehaviour horiz = widget.mListDimensionBehaviors[0];
            ConstraintWidget.DimensionBehaviour vert = widget.mListDimensionBehaviors[1];
            if (widget.getVisibility() == 8) {
                widget.measured = true;
                continue;
            }
            if (widget.mMatchConstraintPercentWidth < 1.0f && horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.mMatchConstraintDefaultWidth = 2;
            }
            if (widget.mMatchConstraintPercentHeight < 1.0f && vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widget.mMatchConstraintDefaultHeight = 2;
            }
            if (widget.getDimensionRatio() > 0.0f) {
                if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vert == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vert == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.mMatchConstraintDefaultWidth = 3;
                } else if (vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horiz == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horiz == ConstraintWidget.DimensionBehaviour.FIXED)) {
                    widget.mMatchConstraintDefaultHeight = 3;
                } else if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    if (widget.mMatchConstraintDefaultWidth == 0) {
                        widget.mMatchConstraintDefaultWidth = 3;
                    }
                    if (widget.mMatchConstraintDefaultHeight == 0) {
                        widget.mMatchConstraintDefaultHeight = 3;
                    }
                }
            }
            if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultWidth == 1 && (widget.mLeft.mTarget == null || widget.mRight.mTarget == null)) {
                horiz = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            if (vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultHeight == 1 && (widget.mTop.mTarget == null || widget.mBottom.mTarget == null)) {
                vert = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            widget.horizontalRun.dimensionBehavior = horiz;
            widget.horizontalRun.matchConstraintsType = widget.mMatchConstraintDefaultWidth;
            widget.verticalRun.dimensionBehavior = vert;
            widget.verticalRun.matchConstraintsType = widget.mMatchConstraintDefaultHeight;
            if (!(horiz != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && horiz != ConstraintWidget.DimensionBehaviour.FIXED && horiz != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vert != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && vert != ConstraintWidget.DimensionBehaviour.FIXED && vert != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT)) {
                int width = widget.getWidth();
                if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    width = constraintWidgetContainer.getWidth() - widget.mLeft.mMargin - widget.mRight.mMargin;
                    horiz = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                int height2 = widget.getHeight();
                if (vert == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    height2 = constraintWidgetContainer.getHeight() - widget.mTop.mMargin - widget.mBottom.mMargin;
                    vert = ConstraintWidget.DimensionBehaviour.FIXED;
                }
                this.measure(widget, horiz, width, vert, height2);
                widget.horizontalRun.dimension.resolve(widget.getWidth());
                widget.verticalRun.dimension.resolve(widget.getHeight());
                widget.measured = true;
                continue;
            }
            if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (vert == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vert == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.mMatchConstraintDefaultWidth == 3) {
                    if (vert == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int height3 = widget.getHeight();
                    int width = (int)((float)height3 * widget.mDimensionRatio + 0.5f);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height3);
                    widget.horizontalRun.dimension.resolve(widget.getWidth());
                    widget.verticalRun.dimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
                if (widget.mMatchConstraintDefaultWidth == 1) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vert, 0);
                    widget.horizontalRun.dimension.wrapValue = widget.getWidth();
                    continue;
                }
                if (widget.mMatchConstraintDefaultWidth == 2) {
                    if (constraintWidgetContainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.mMatchConstraintPercentWidth;
                        int width = (int)(0.5f + percent * (float)constraintWidgetContainer.getWidth());
                        height = widget.getHeight();
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, vert, height);
                        widget.horizontalRun.dimension.resolve(widget.getWidth());
                        widget.verticalRun.dimension.resolve(widget.getHeight());
                        widget.measured = true;
                        continue;
                    }
                } else if (widget.mListAnchors[0].mTarget == null || widget.mListAnchors[1].mTarget == null) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vert, 0);
                    widget.horizontalRun.dimension.resolve(widget.getWidth());
                    widget.verticalRun.dimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
            }
            if (vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && (horiz == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horiz == ConstraintWidget.DimensionBehaviour.FIXED)) {
                if (widget.mMatchConstraintDefaultHeight == 3) {
                    if (horiz == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    }
                    int width = widget.getWidth();
                    float ratio = widget.mDimensionRatio;
                    if (widget.getDimensionRatioSide() == -1) {
                        ratio = 1.0f / ratio;
                    }
                    height = (int)((float)width * ratio + 0.5f);
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                    widget.horizontalRun.dimension.resolve(widget.getWidth());
                    widget.verticalRun.dimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
                if (widget.mMatchConstraintDefaultHeight == 1) {
                    this.measure(widget, horiz, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                    widget.verticalRun.dimension.wrapValue = widget.getHeight();
                    continue;
                }
                if (widget.mMatchConstraintDefaultHeight == 2) {
                    if (constraintWidgetContainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[1] == ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        float percent = widget.mMatchConstraintPercentHeight;
                        int width = widget.getWidth();
                        height = (int)(0.5f + percent * (float)constraintWidgetContainer.getHeight());
                        this.measure(widget, horiz, width, ConstraintWidget.DimensionBehaviour.FIXED, height);
                        widget.horizontalRun.dimension.resolve(widget.getWidth());
                        widget.verticalRun.dimension.resolve(widget.getHeight());
                        widget.measured = true;
                        continue;
                    }
                } else if (widget.mListAnchors[2].mTarget == null || widget.mListAnchors[3].mTarget == null) {
                    this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, vert, 0);
                    widget.horizontalRun.dimension.resolve(widget.getWidth());
                    widget.verticalRun.dimension.resolve(widget.getHeight());
                    widget.measured = true;
                    continue;
                }
            }
            if (horiz != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT || vert != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) continue;
            if (widget.mMatchConstraintDefaultWidth == 1 || widget.mMatchConstraintDefaultHeight == 1) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, 0);
                widget.horizontalRun.dimension.wrapValue = widget.getWidth();
                widget.verticalRun.dimension.wrapValue = widget.getHeight();
                continue;
            }
            if (widget.mMatchConstraintDefaultHeight != 2 || widget.mMatchConstraintDefaultWidth != 2 || constraintWidgetContainer.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.FIXED && constraintWidgetContainer.mListDimensionBehaviors[0] != ConstraintWidget.DimensionBehaviour.FIXED || constraintWidgetContainer.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.FIXED && constraintWidgetContainer.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.FIXED) continue;
            float horizPercent = widget.mMatchConstraintPercentWidth;
            float vertPercent = widget.mMatchConstraintPercentHeight;
            int width = (int)(0.5f + horizPercent * (float)constraintWidgetContainer.getWidth());
            int height4 = (int)(0.5f + vertPercent * (float)constraintWidgetContainer.getHeight());
            this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, width, ConstraintWidget.DimensionBehaviour.FIXED, height4);
            widget.horizontalRun.dimension.resolve(widget.getWidth());
            widget.verticalRun.dimension.resolve(widget.getHeight());
            widget.measured = true;
        }
        return false;
    }

    public void measureWidgets() {
        for (ConstraintWidget widget : this.container.mChildren) {
            if (widget.measured) continue;
            ConstraintWidget.DimensionBehaviour horiz = widget.mListDimensionBehaviors[0];
            ConstraintWidget.DimensionBehaviour vert = widget.mListDimensionBehaviors[1];
            int horizMatchConstraintsType = widget.mMatchConstraintDefaultWidth;
            int vertMatchConstraintsType = widget.mMatchConstraintDefaultHeight;
            boolean horizWrap = horiz == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && horizMatchConstraintsType == 1;
            boolean vertWrap = vert == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && vertMatchConstraintsType == 1;
            boolean horizResolved = widget.horizontalRun.dimension.resolved;
            boolean vertResolved = widget.verticalRun.dimension.resolved;
            if (horizResolved && vertResolved) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, widget.horizontalRun.dimension.value, ConstraintWidget.DimensionBehaviour.FIXED, widget.verticalRun.dimension.value);
                widget.measured = true;
            } else if (horizResolved && vertWrap) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.FIXED, widget.horizontalRun.dimension.value, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, widget.verticalRun.dimension.value);
                if (vert == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    widget.verticalRun.dimension.wrapValue = widget.getHeight();
                } else {
                    widget.verticalRun.dimension.resolve(widget.getHeight());
                    widget.measured = true;
                }
            } else if (vertResolved && horizWrap) {
                this.measure(widget, ConstraintWidget.DimensionBehaviour.WRAP_CONTENT, widget.horizontalRun.dimension.value, ConstraintWidget.DimensionBehaviour.FIXED, widget.verticalRun.dimension.value);
                if (horiz == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    widget.horizontalRun.dimension.wrapValue = widget.getWidth();
                } else {
                    widget.horizontalRun.dimension.resolve(widget.getWidth());
                    widget.measured = true;
                }
            }
            if (!widget.measured || widget.verticalRun.baselineDimension == null) continue;
            widget.verticalRun.baselineDimension.resolve(widget.getBaselineDistance());
        }
    }

    public void invalidateGraph() {
        this.mNeedBuildGraph = true;
    }

    public void invalidateMeasures() {
        this.mNeedRedoMeasures = true;
    }

    public void buildGraph() {
        this.buildGraph(this.mRuns);
        this.mGroups.clear();
        RunGroup.index = 0;
        this.findGroup(this.container.horizontalRun, 0, this.mGroups);
        this.findGroup(this.container.verticalRun, 1, this.mGroups);
        this.mNeedBuildGraph = false;
    }

    public void buildGraph(ArrayList<WidgetRun> runs) {
        runs.clear();
        this.mContainer.horizontalRun.clear();
        this.mContainer.verticalRun.clear();
        runs.add(this.mContainer.horizontalRun);
        runs.add(this.mContainer.verticalRun);
        HashSet<ChainRun> chainRuns = null;
        for (ConstraintWidget widget : this.mContainer.mChildren) {
            ChainRun chainRun;
            if (widget instanceof Guideline) {
                runs.add(new GuidelineReference(widget));
                continue;
            }
            if (widget.isInHorizontalChain()) {
                if (widget.horizontalChainRun == null) {
                    widget.horizontalChainRun = chainRun = new ChainRun(widget, 0);
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet<ChainRun>();
                }
                chainRuns.add(widget.horizontalChainRun);
            } else {
                runs.add(widget.horizontalRun);
            }
            if (widget.isInVerticalChain()) {
                if (widget.verticalChainRun == null) {
                    widget.verticalChainRun = chainRun = new ChainRun(widget, 1);
                }
                if (chainRuns == null) {
                    chainRuns = new HashSet();
                }
                chainRuns.add(widget.verticalChainRun);
            } else {
                runs.add(widget.verticalRun);
            }
            if (!(widget instanceof HelperWidget)) continue;
            runs.add(new HelperReferences(widget));
        }
        if (chainRuns != null) {
            runs.addAll(chainRuns);
        }
        for (WidgetRun run : runs) {
            run.clear();
        }
        for (WidgetRun run : runs) {
            if (run.widget == this.mContainer) continue;
            run.apply();
        }
    }

    private void displayGraph() {
        String content = "digraph {\n";
        for (WidgetRun run : this.mRuns) {
            content = this.generateDisplayGraph(run, content);
        }
        content = content + "\n}\n";
        System.out.println("content:<<\n" + content + "\n>>");
    }

    private void applyGroup(DependencyNode node, int orientation, int direction, DependencyNode end, ArrayList<RunGroup> groups, RunGroup group) {
        WidgetRun run = node.run;
        if (run.runGroup != null || run == this.container.horizontalRun || run == this.container.verticalRun) {
            return;
        }
        if (group == null) {
            group = new RunGroup(run, direction);
            groups.add(group);
        }
        run.runGroup = group;
        group.add(run);
        for (Dependency dependent : run.start.dependencies) {
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 0, end, groups, group);
        }
        for (Dependency dependent : run.end.dependencies) {
            if (!(dependent instanceof DependencyNode)) continue;
            this.applyGroup((DependencyNode)dependent, orientation, 1, end, groups, group);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            for (Dependency dependent : ((VerticalWidgetRun)run).baseline.dependencies) {
                if (!(dependent instanceof DependencyNode)) continue;
                this.applyGroup((DependencyNode)dependent, orientation, 2, end, groups, group);
            }
        }
        for (DependencyNode target : run.start.targets) {
            if (target == end) {
                group.dual = true;
            }
            this.applyGroup(target, orientation, 0, end, groups, group);
        }
        for (DependencyNode target : run.end.targets) {
            if (target == end) {
                group.dual = true;
            }
            this.applyGroup(target, orientation, 1, end, groups, group);
        }
        if (orientation == 1 && run instanceof VerticalWidgetRun) {
            for (DependencyNode target : ((VerticalWidgetRun)run).baseline.targets) {
                this.applyGroup(target, orientation, 2, end, groups, group);
            }
        }
    }

    private void findGroup(WidgetRun run, int orientation, ArrayList<RunGroup> groups) {
        WidgetRun dependentRun;
        DependencyNode node;
        for (Dependency dependent : run.start.dependencies) {
            if (dependent instanceof DependencyNode) {
                node = (DependencyNode)dependent;
                this.applyGroup(node, orientation, 0, run.end, groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            dependentRun = (WidgetRun)dependent;
            this.applyGroup(dependentRun.start, orientation, 0, run.end, groups, null);
        }
        for (Dependency dependent : run.end.dependencies) {
            if (dependent instanceof DependencyNode) {
                node = (DependencyNode)dependent;
                this.applyGroup(node, orientation, 1, run.start, groups, null);
                continue;
            }
            if (!(dependent instanceof WidgetRun)) continue;
            dependentRun = (WidgetRun)dependent;
            this.applyGroup(dependentRun.end, orientation, 1, run.start, groups, null);
        }
        if (orientation == 1) {
            for (Dependency dependent : ((VerticalWidgetRun)run).baseline.dependencies) {
                if (!(dependent instanceof DependencyNode)) continue;
                node = (DependencyNode)dependent;
                this.applyGroup(node, orientation, 2, null, groups, null);
            }
        }
    }

    private String generateDisplayNode(DependencyNode node, boolean centeredConnection, String content) {
        for (DependencyNode target : node.targets) {
            String constraint = "\n" + node.name();
            constraint = constraint + " -> " + target.name();
            if (node.margin > 0 || centeredConnection || node.run instanceof HelperReferences) {
                constraint = constraint + "[";
                if (node.margin > 0) {
                    constraint = constraint + "label=\"" + node.margin + "\"";
                    if (centeredConnection) {
                        constraint = constraint + ",";
                    }
                }
                if (centeredConnection) {
                    constraint = constraint + " style=dashed ";
                }
                if (node.run instanceof HelperReferences) {
                    constraint = constraint + " style=bold,color=gray ";
                }
                constraint = constraint + "]";
            }
            constraint = constraint + "\n";
            content = content + constraint;
        }
        return content;
    }

    private String nodeDefinition(WidgetRun run) {
        String name;
        boolean orientation = run instanceof VerticalWidgetRun;
        String definition = name = run.widget.getDebugName();
        ConstraintWidget.DimensionBehaviour behaviour = !orientation ? run.widget.getHorizontalDimensionBehaviour() : run.widget.getVerticalDimensionBehaviour();
        RunGroup runGroup = run.runGroup;
        definition = !orientation ? definition + "_HORIZONTAL" : definition + "_VERTICAL";
        definition = definition + " [shape=none, label=<";
        definition = definition + "<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"2\">";
        definition = definition + "  <TR>";
        if (!orientation) {
            definition = definition + "    <TD ";
            if (run.start.resolved) {
                definition = definition + " BGCOLOR=\"green\"";
            }
            definition = definition + " PORT=\"LEFT\" BORDER=\"1\">L</TD>";
        } else {
            definition = definition + "    <TD ";
            if (run.start.resolved) {
                definition = definition + " BGCOLOR=\"green\"";
            }
            definition = definition + " PORT=\"TOP\" BORDER=\"1\">T</TD>";
        }
        definition = definition + "    <TD BORDER=\"1\" ";
        if (run.dimension.resolved && !run.widget.measured) {
            definition = definition + " BGCOLOR=\"green\" ";
        } else if (run.dimension.resolved && run.widget.measured) {
            definition = definition + " BGCOLOR=\"lightgray\" ";
        } else if (!run.dimension.resolved && run.widget.measured) {
            definition = definition + " BGCOLOR=\"yellow\" ";
        }
        if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            definition = definition + "style=\"dashed\"";
        }
        String group = "";
        if (runGroup != null) {
            group = " [" + (runGroup.groupIndex + 1) + "/" + RunGroup.index + "]";
        }
        definition = definition + ">" + name + group + " </TD>";
        if (!orientation) {
            definition = definition + "    <TD ";
            if (run.end.resolved) {
                definition = definition + " BGCOLOR=\"green\"";
            }
            definition = definition + " PORT=\"RIGHT\" BORDER=\"1\">R</TD>";
        } else {
            definition = definition + "    <TD ";
            if (run instanceof VerticalWidgetRun && ((VerticalWidgetRun)run).baseline.resolved) {
                definition = definition + " BGCOLOR=\"green\"";
            }
            definition = definition + " PORT=\"BASELINE\" BORDER=\"1\">b</TD>";
            definition = definition + "    <TD ";
            if (run.end.resolved) {
                definition = definition + " BGCOLOR=\"green\"";
            }
            definition = definition + " PORT=\"BOTTOM\" BORDER=\"1\">B</TD>";
        }
        definition = definition + "  </TR></TABLE>";
        definition = definition + ">];\n";
        return definition;
    }

    private String generateChainDisplayGraph(ChainRun chain, String content) {
        int orientation = chain.orientation;
        String name = "cluster_" + chain.widget.getDebugName();
        name = orientation == 0 ? name + "_h" : name + "_v";
        String subgroup = "subgraph " + name + " {\n";
        String definitions = "";
        for (WidgetRun run : chain.widgets) {
            String runName = run.widget.getDebugName();
            runName = orientation == 0 ? runName + "_HORIZONTAL" : runName + "_VERTICAL";
            subgroup = subgroup + runName + ";\n";
            definitions = this.generateDisplayGraph(run, definitions);
        }
        subgroup = subgroup + "}\n";
        return content + definitions + subgroup;
    }

    private boolean isCenteredConnection(DependencyNode start, DependencyNode end) {
        int startTargets = 0;
        int endTargets = 0;
        for (DependencyNode s : start.targets) {
            if (s == end) continue;
            ++startTargets;
        }
        for (DependencyNode e : end.targets) {
            if (e == start) continue;
            ++endTargets;
        }
        return startTargets > 0 && endTargets > 0;
    }

    private String generateDisplayGraph(WidgetRun root, String content) {
        ConstraintWidget.DimensionBehaviour behaviour;
        DependencyNode start = root.start;
        DependencyNode end = root.end;
        if (!(root instanceof HelperReferences) && start.dependencies.isEmpty() && end.dependencies.isEmpty() & start.targets.isEmpty() && end.targets.isEmpty()) {
            return content;
        }
        content = content + this.nodeDefinition(root);
        boolean centeredConnection = this.isCenteredConnection(start, end);
        content = this.generateDisplayNode(start, centeredConnection, content);
        content = this.generateDisplayNode(end, centeredConnection, content);
        if (root instanceof VerticalWidgetRun) {
            DependencyNode baseline = ((VerticalWidgetRun)root).baseline;
            content = this.generateDisplayNode(baseline, centeredConnection, content);
        }
        if (root instanceof HorizontalWidgetRun || root instanceof ChainRun && ((ChainRun)root).orientation == 0) {
            behaviour = root.widget.getHorizontalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.targets.isEmpty() && end.targets.isEmpty()) {
                    String constraint = "\n" + end.name() + " -> " + start.name() + "\n";
                    content = content + constraint;
                } else if (start.targets.isEmpty() && !end.targets.isEmpty()) {
                    String constraint = "\n" + start.name() + " -> " + end.name() + "\n";
                    content = content + constraint;
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && root.widget.getDimensionRatio() > 0.0f) {
                String name = root.widget.getDebugName();
                String string = "\n" + name + "_HORIZONTAL -> " + name + "_VERTICAL;\n";
            }
        } else if (root instanceof VerticalWidgetRun || root instanceof ChainRun && ((ChainRun)root).orientation == 1) {
            behaviour = root.widget.getVerticalDimensionBehaviour();
            if (behaviour == ConstraintWidget.DimensionBehaviour.FIXED || behaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (!start.targets.isEmpty() && end.targets.isEmpty()) {
                    String constraint = "\n" + end.name() + " -> " + start.name() + "\n";
                    content = content + constraint;
                } else if (start.targets.isEmpty() && !end.targets.isEmpty()) {
                    String constraint = "\n" + start.name() + " -> " + end.name() + "\n";
                    content = content + constraint;
                }
            } else if (behaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && root.widget.getDimensionRatio() > 0.0f) {
                String name = root.widget.getDebugName();
                String string = "\n" + name + "_VERTICAL -> " + name + "_HORIZONTAL;\n";
            }
        }
        if (root instanceof ChainRun) {
            return this.generateChainDisplayGraph((ChainRun)root, content);
        }
        return content;
    }
}

