/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.font;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.fonts.FontVariationAxis;
import android.os.ParcelFileDescriptor;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.font.FontVariation;
import androidx.compose.ui.unit.AndroidDensity_androidKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J$\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J$\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0003\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Landroidx/compose/ui/text/font/TypefaceBuilderCompat;", "", "()V", "createFromAssets", "Landroid/graphics/Typeface;", "assetManager", "Landroid/content/res/AssetManager;", "path", "", "context", "Landroid/content/Context;", "variationSettings", "Landroidx/compose/ui/text/font/FontVariation$Settings;", "createFromFile", "file", "Ljava/io/File;", "createFromFileDescriptor", "fileDescriptor", "Landroid/os/ParcelFileDescriptor;", "toVariationSettings", "", "Landroid/graphics/fonts/FontVariationAxis;", "(Landroidx/compose/ui/text/font/FontVariation$Settings;Landroid/content/Context;)[Landroid/graphics/fonts/FontVariationAxis;", "ui-text_release"})
@RequiresApi(api=26)
@SourceDebugExtension(value={"SMAP\nAndroidPreloadedFont.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPreloadedFont.android.kt\nandroidx/compose/ui/text/font/TypefaceBuilderCompat\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,234:1\n151#2,3:235\n33#2,4:238\n154#2,2:242\n38#2:244\n156#2:245\n37#3,2:246\n*S KotlinDebug\n*F\n+ 1 AndroidPreloadedFont.android.kt\nandroidx/compose/ui/text/font/TypefaceBuilderCompat\n*L\n229#1:235,3\n229#1:238,4\n229#1:242,2\n229#1:244\n229#1:245\n231#1:246,2\n*E\n"})
final class TypefaceBuilderCompat {
    @NotNull
    public static final TypefaceBuilderCompat INSTANCE = new TypefaceBuilderCompat();

    private TypefaceBuilderCompat() {
    }

    @ExperimentalTextApi
    @DoNotInline
    @Nullable
    public final Typeface createFromAssets(@NotNull AssetManager assetManager, @NotNull String path, @Nullable Context context, @NotNull FontVariation.Settings variationSettings) {
        if (context == null) {
            return null;
        }
        return new Typeface.Builder(assetManager, path).setFontVariationSettings(this.toVariationSettings(variationSettings, context)).build();
    }

    @ExperimentalTextApi
    @DoNotInline
    @Nullable
    public final Typeface createFromFile(@NotNull File file, @Nullable Context context, @NotNull FontVariation.Settings variationSettings) {
        if (context == null) {
            return null;
        }
        return new Typeface.Builder(file).setFontVariationSettings(this.toVariationSettings(variationSettings, context)).build();
    }

    @ExperimentalTextApi
    @DoNotInline
    @Nullable
    public final Typeface createFromFileDescriptor(@NotNull ParcelFileDescriptor fileDescriptor, @Nullable Context context, @NotNull FontVariation.Settings variationSettings) {
        if (context == null) {
            return null;
        }
        return new Typeface.Builder(fileDescriptor.getFileDescriptor()).setFontVariationSettings(this.toVariationSettings(variationSettings, context)).build();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    @ExperimentalTextApi
    private final FontVariationAxis[] toVariationSettings(FontVariation.Settings $this$toVariationSettings, Context context) {
        void $this$toTypedArray$iv;
        Density density;
        if (context != null) {
            density = AndroidDensity_androidKt.Density((Context)context);
        } else if (!$this$toVariationSettings.getNeedsDensity$ui_text_release()) {
            density = DensityKt.Density((float)1.0f, (float)1.0f);
        } else {
            throw new IllegalStateException("Required density, but not provided");
        }
        Density density2 = density;
        Collection<FontVariation.Setting> $this$fastMap$iv = $this$toVariationSettings.getSettings();
        boolean $i$f$fastMap = false;
        ArrayList target$iv = new ArrayList($this$fastMap$iv.size());
        List<FontVariation.Setting> $this$fastForEach$iv$iv = $this$fastMap$iv;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            void setting;
            FontVariation.Setting item$iv$iv;
            FontVariation.Setting it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            FontVariation.Setting setting2 = it$iv;
            Collection collection = target$iv;
            boolean bl2 = false;
            collection.add(new FontVariationAxis(setting.getAxisName(), setting.toVariationValue(density2)));
        }
        $this$fastMap$iv = target$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FontVariationAxis[0]);
    }
}

