/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android;

import android.graphics.RectF;
import android.text.Layout;
import androidx.compose.ui.text.android.LayoutHelper;
import androidx.compose.ui.text.android.TextLayout;
import androidx.compose.ui.text.android.selection.SegmentFinder;
import androidx.compose.ui.text.android.selection.SegmentFinder_androidKt;
import androidx.compose.ui.text.android.selection.WordSegmentFinder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001af\u0010\b\u001a\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001aH\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00032\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u001af\u0010\u001d\u001a\u00020\u0003*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u001aV\u0010\u001e\u001a\u00020\u0003*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010 \u001a\u00020\u0014H\u0002\u001a\u001c\u0010!\u001a\u00020\u0014*\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0001H\u0002\u00a8\u0006$"}, d2={"getCharacterLeftBounds", "", "offset", "", "lineStart", "horizontalBounds", "", "getCharacterRightBounds", "getEndOffsetForRectWithinRun", "Landroidx/compose/ui/text/android/LayoutHelper$BidiRun;", "rect", "Landroid/graphics/RectF;", "lineTop", "lineBottom", "runLeft", "runRight", "segmentFinder", "Landroidx/compose/ui/text/android/selection/SegmentFinder;", "inclusionStrategy", "Lkotlin/Function2;", "", "getRangeForRect", "", "Landroidx/compose/ui/text/android/TextLayout;", "layout", "Landroid/text/Layout;", "layoutHelper", "Landroidx/compose/ui/text/android/LayoutHelper;", "granularity", "getStartOffsetForRectWithinRun", "getStartOrEndOffsetForRectWithinLine", "lineIndex", "getStart", "horizontalOverlap", "left", "right", "ui-text_release"})
public final class TextLayoutGetRangeForRectExtensions_androidKt {
    @Nullable
    public static final int[] getRangeForRect(@NotNull TextLayout $this$getRangeForRect, @NotNull Layout layout, @NotNull LayoutHelper layoutHelper, @NotNull RectF rect, int granularity, @NotNull Function2<? super RectF, ? super RectF, Boolean> inclusionStrategy) {
        int endLine;
        SegmentFinder segmentFinder = granularity == 1 ? (SegmentFinder)new WordSegmentFinder($this$getRangeForRect.getText(), $this$getRangeForRect.getWordIterator()) : SegmentFinder_androidKt.createGraphemeClusterSegmentFinder($this$getRangeForRect.getText(), $this$getRangeForRect.getTextPaint());
        int startLine = layout.getLineForVertical((int)rect.top);
        if (rect.top > $this$getRangeForRect.getLineBottom(startLine)) {
            if (++startLine >= $this$getRangeForRect.getLineCount()) {
                return null;
            }
        }
        if ((endLine = layout.getLineForVertical((int)rect.bottom)) == 0 && rect.bottom < $this$getRangeForRect.getLineTop(0)) {
            return null;
        }
        int start = TextLayoutGetRangeForRectExtensions_androidKt.getStartOrEndOffsetForRectWithinLine($this$getRangeForRect, layout, layoutHelper, startLine, rect, segmentFinder, inclusionStrategy, true);
        while (start == -1 && startLine < endLine) {
            start = TextLayoutGetRangeForRectExtensions_androidKt.getStartOrEndOffsetForRectWithinLine($this$getRangeForRect, layout, layoutHelper, ++startLine, rect, segmentFinder, inclusionStrategy, true);
        }
        if (start == -1) {
            return null;
        }
        int end = TextLayoutGetRangeForRectExtensions_androidKt.getStartOrEndOffsetForRectWithinLine($this$getRangeForRect, layout, layoutHelper, endLine, rect, segmentFinder, inclusionStrategy, false);
        while (end == -1 && startLine < endLine) {
            end = TextLayoutGetRangeForRectExtensions_androidKt.getStartOrEndOffsetForRectWithinLine($this$getRangeForRect, layout, layoutHelper, --endLine, rect, segmentFinder, inclusionStrategy, false);
        }
        if (end == -1) {
            return null;
        }
        start = segmentFinder.previousStartBoundary(start + 1);
        end = segmentFinder.nextEndBoundary(end - 1);
        int[] nArray = new int[]{start, end};
        return nArray;
    }

    private static final int getStartOrEndOffsetForRectWithinLine(TextLayout $this$getStartOrEndOffsetForRectWithinLine, Layout layout, LayoutHelper layoutHelper, int lineIndex, RectF rect, SegmentFinder segmentFinder, Function2<? super RectF, ? super RectF, Boolean> inclusionStrategy, boolean getStart) {
        int lineEnd;
        int lineTop = layout.getLineTop(lineIndex);
        int lineBottom = layout.getLineBottom(lineIndex);
        int lineStart = layout.getLineStart(lineIndex);
        if (lineStart == (lineEnd = layout.getLineEnd(lineIndex))) {
            return -1;
        }
        float[] horizontalBounds = new float[2 * (lineEnd - lineStart)];
        $this$getStartOrEndOffsetForRectWithinLine.fillLineHorizontalBounds$ui_text_release(lineIndex, horizontalBounds);
        Object[] bidiRuns = layoutHelper.getLineBidiRuns$ui_text_release(lineIndex);
        IntProgression range2 = getStart ? (IntProgression)ArraysKt.getIndices((Object[])bidiRuns) : RangesKt.downTo((int)ArraysKt.getLastIndex((Object[])bidiRuns), (int)0);
        int runIndex = range2.getFirst();
        int n = range2.getLast();
        int n2 = range2.getStep();
        if (n2 > 0 && runIndex <= n || n2 < 0 && n <= runIndex) {
            while (true) {
                int result2;
                Object bidiRun;
                float runLeft = ((LayoutHelper.BidiRun)(bidiRun = bidiRuns[runIndex])).isRtl() ? TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(((LayoutHelper.BidiRun)bidiRun).getEnd() - 1, lineStart, horizontalBounds) : TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(((LayoutHelper.BidiRun)bidiRun).getStart(), lineStart, horizontalBounds);
                float runRight = ((LayoutHelper.BidiRun)bidiRun).isRtl() ? TextLayoutGetRangeForRectExtensions_androidKt.getCharacterRightBounds(((LayoutHelper.BidiRun)bidiRun).getStart(), lineStart, horizontalBounds) : TextLayoutGetRangeForRectExtensions_androidKt.getCharacterRightBounds(((LayoutHelper.BidiRun)bidiRun).getEnd() - 1, lineStart, horizontalBounds);
                int n3 = result2 = getStart ? TextLayoutGetRangeForRectExtensions_androidKt.getStartOffsetForRectWithinRun((LayoutHelper.BidiRun)bidiRun, rect, lineStart, lineTop, lineBottom, runLeft, runRight, horizontalBounds, segmentFinder, inclusionStrategy) : TextLayoutGetRangeForRectExtensions_androidKt.getEndOffsetForRectWithinRun((LayoutHelper.BidiRun)bidiRun, rect, lineStart, lineTop, lineBottom, runLeft, runRight, horizontalBounds, segmentFinder, inclusionStrategy);
                if (result2 >= 0) {
                    return result2;
                }
                if (runIndex == n) break;
                runIndex += n2;
            }
        }
        return -1;
    }

    private static final int getStartOffsetForRectWithinRun(LayoutHelper.BidiRun $this$getStartOffsetForRectWithinRun, RectF rect, int lineStart, int lineTop, int lineBottom, float runLeft, float runRight, float[] horizontalBounds, SegmentFinder segmentFinder, Function2<? super RectF, ? super RectF, Boolean> inclusionStrategy) {
        if (!TextLayoutGetRangeForRectExtensions_androidKt.horizontalOverlap(rect, runLeft, runRight)) {
            return -1;
        }
        int firstCharOffset = 0;
        if (!$this$getStartOffsetForRectWithinRun.isRtl() && rect.left <= runLeft || $this$getStartOffsetForRectWithinRun.isRtl() && rect.right >= runRight) {
            firstCharOffset = $this$getStartOffsetForRectWithinRun.getStart();
        } else {
            int low = $this$getStartOffsetForRectWithinRun.getStart();
            int high = $this$getStartOffsetForRectWithinRun.getEnd();
            while (high - low > 1) {
                int guess = (high + low) / 2;
                float position = TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(guess, lineStart, horizontalBounds);
                if (!$this$getStartOffsetForRectWithinRun.isRtl() && position > rect.left || $this$getStartOffsetForRectWithinRun.isRtl() && position < rect.right) {
                    high = guess;
                    continue;
                }
                low = guess;
            }
            firstCharOffset = $this$getStartOffsetForRectWithinRun.isRtl() ? high : low;
        }
        int segmentEnd = segmentFinder.nextEndBoundary(firstCharOffset);
        if (segmentEnd == -1) {
            return -1;
        }
        int segmentStart = segmentFinder.previousStartBoundary(segmentEnd);
        if (segmentStart >= $this$getStartOffsetForRectWithinRun.getEnd()) {
            return -1;
        }
        segmentStart = RangesKt.coerceAtLeast((int)segmentStart, (int)$this$getStartOffsetForRectWithinRun.getStart());
        segmentEnd = RangesKt.coerceAtMost((int)segmentEnd, (int)$this$getStartOffsetForRectWithinRun.getEnd());
        RectF textBounds = new RectF(0.0f, (float)lineTop, 0.0f, (float)lineBottom);
        while (true) {
            textBounds.left = $this$getStartOffsetForRectWithinRun.isRtl() ? TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(segmentEnd - 1, lineStart, horizontalBounds) : TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(segmentStart, lineStart, horizontalBounds);
            float f = textBounds.right = $this$getStartOffsetForRectWithinRun.isRtl() ? TextLayoutGetRangeForRectExtensions_androidKt.getCharacterRightBounds(segmentStart, lineStart, horizontalBounds) : TextLayoutGetRangeForRectExtensions_androidKt.getCharacterRightBounds(segmentEnd - 1, lineStart, horizontalBounds);
            if (((Boolean)inclusionStrategy.invoke((Object)textBounds, (Object)rect)).booleanValue()) {
                return segmentStart;
            }
            if ((segmentStart = segmentFinder.nextStartBoundary(segmentStart)) == -1 || segmentStart >= $this$getStartOffsetForRectWithinRun.getEnd()) {
                return -1;
            }
            segmentEnd = RangesKt.coerceAtMost((int)segmentFinder.nextEndBoundary(segmentStart), (int)$this$getStartOffsetForRectWithinRun.getEnd());
        }
    }

    private static final int getEndOffsetForRectWithinRun(LayoutHelper.BidiRun $this$getEndOffsetForRectWithinRun, RectF rect, int lineStart, int lineTop, int lineBottom, float runLeft, float runRight, float[] horizontalBounds, SegmentFinder segmentFinder, Function2<? super RectF, ? super RectF, Boolean> inclusionStrategy) {
        if (!TextLayoutGetRangeForRectExtensions_androidKt.horizontalOverlap(rect, runLeft, runRight)) {
            return -1;
        }
        int lastCharOffset = 0;
        if (!$this$getEndOffsetForRectWithinRun.isRtl() && rect.right >= runRight || $this$getEndOffsetForRectWithinRun.isRtl() && rect.left <= runLeft) {
            lastCharOffset = $this$getEndOffsetForRectWithinRun.getEnd() - 1;
        } else {
            int low = $this$getEndOffsetForRectWithinRun.getStart();
            int high = $this$getEndOffsetForRectWithinRun.getEnd();
            while (high - low > 1) {
                int guess = (high + low) / 2;
                float position = TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(guess, lineStart, horizontalBounds);
                if (!$this$getEndOffsetForRectWithinRun.isRtl() && position > rect.right || $this$getEndOffsetForRectWithinRun.isRtl() && position < rect.left) {
                    high = guess;
                    continue;
                }
                low = guess;
            }
            lastCharOffset = $this$getEndOffsetForRectWithinRun.isRtl() ? high : low;
        }
        int segmentStart = segmentFinder.previousStartBoundary(lastCharOffset + 1);
        if (segmentStart == -1) {
            return -1;
        }
        int segmentEnd = segmentFinder.nextEndBoundary(segmentStart);
        if (segmentEnd <= $this$getEndOffsetForRectWithinRun.getStart()) {
            return -1;
        }
        segmentStart = RangesKt.coerceAtLeast((int)segmentStart, (int)$this$getEndOffsetForRectWithinRun.getStart());
        segmentEnd = RangesKt.coerceAtMost((int)segmentEnd, (int)$this$getEndOffsetForRectWithinRun.getEnd());
        RectF textBounds = new RectF(0.0f, (float)lineTop, 0.0f, (float)lineBottom);
        while (true) {
            textBounds.left = $this$getEndOffsetForRectWithinRun.isRtl() ? TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(segmentEnd - 1, lineStart, horizontalBounds) : TextLayoutGetRangeForRectExtensions_androidKt.getCharacterLeftBounds(segmentStart, lineStart, horizontalBounds);
            float f = textBounds.right = $this$getEndOffsetForRectWithinRun.isRtl() ? TextLayoutGetRangeForRectExtensions_androidKt.getCharacterRightBounds(segmentStart, lineStart, horizontalBounds) : TextLayoutGetRangeForRectExtensions_androidKt.getCharacterRightBounds(segmentEnd - 1, lineStart, horizontalBounds);
            if (((Boolean)inclusionStrategy.invoke((Object)textBounds, (Object)rect)).booleanValue()) {
                return segmentEnd;
            }
            if ((segmentEnd = segmentFinder.previousEndBoundary(segmentEnd)) == -1 || segmentEnd <= $this$getEndOffsetForRectWithinRun.getStart()) {
                return -1;
            }
            segmentStart = RangesKt.coerceAtLeast((int)segmentFinder.previousStartBoundary(segmentEnd), (int)$this$getEndOffsetForRectWithinRun.getStart());
        }
    }

    private static final float getCharacterLeftBounds(int offset, int lineStart, float[] horizontalBounds) {
        return horizontalBounds[2 * (offset - lineStart)];
    }

    private static final float getCharacterRightBounds(int offset, int lineStart, float[] horizontalBounds) {
        return horizontalBounds[2 * (offset - lineStart) + 1];
    }

    private static final boolean horizontalOverlap(RectF $this$horizontalOverlap, float left, float right) {
        return right >= $this$horizontalOverlap.left && left <= $this$horizontalOverlap.right;
    }
}

