/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/compose/ui/text/lint/LocaleInvalidLanguageTagDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "Companion", "ui-text-lint"})
public final class LocaleInvalidLanguageTagDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue InvalidLanguageTagDelimiter = Issue.Companion.create("InvalidLanguageTagDelimiter", "Undercore (_) is an unsupported delimiter for subtags", "A language tag must be compliant with IETF BCP47, specifically a sequence of subtags must be separated by hyphens (-) instead of underscores (_)", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(LocaleInvalidLanguageTagDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        Object[] objectArray = new String[]{"androidx.compose.ui.text.intl.LocaleList", "androidx.compose.ui.text.intl.Locale"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        UExpression languageTag;
        Object v1;
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            object = node.getValueArguments();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                UExpression it = (UExpression)t;
                boolean bl = false;
                PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)it);
                String name = psiParameter != null ? psiParameter.getName() : null;
                if (!(Intrinsics.areEqual((Object)name, (Object)"languageTag") || Intrinsics.areEqual((Object)name, (Object)"languageTags"))) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        UExpression uExpression = v1;
        UExpression uExpression2 = languageTag = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        object = uExpression2 != null ? uExpression2.evaluate() : null;
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        String localeValue = string;
        boolean localeInvalid = StringsKt.contains$default((CharSequence)localeValue, (char)'_', (boolean)false, (int)2, null);
        if (localeInvalid) {
            String fixedLocaleValue = StringsKt.replace$default((String)localeValue, (char)'_', (char)'-', (boolean)false, (int)4, null);
            context.report(InvalidLanguageTagDelimiter, context.getLocation((UElement)languageTag), "A hyphen (-), not an underscore (_) delimiter should be used in a language tag", LintFix.Companion.create().replace().name("Change " + localeValue + " to " + fixedLocaleValue).text(localeValue).with(fixedLocaleValue).autoFix().build());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/text/lint/LocaleInvalidLanguageTagDetector$Companion;", "", "()V", "InvalidLanguageTagDelimiter", "Lcom/android/tools/lint/detector/api/Issue;", "getInvalidLanguageTagDelimiter", "()Lcom/android/tools/lint/detector/api/Issue;", "ui-text-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getInvalidLanguageTagDelimiter() {
            return InvalidLanguageTagDelimiter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

