/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.android.style;

import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.VisibleForTesting;
import androidx.compose.ui.text.android.InternalPlatformTextApi;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalPlatformTextApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B=\u00126\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0014RA\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/android/style/FontSpan;", "Landroid/text/style/MetricAffectingSpan;", "getTypeface", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "weight", "", "isItalic", "Landroid/graphics/Typeface;", "(Lkotlin/jvm/functions/Function2;)V", "getGetTypeface", "()Lkotlin/jvm/functions/Function2;", "updateDrawState", "", "textPaint", "Landroid/text/TextPaint;", "updateMeasureState", "updatePaint", "updatePaint$ui_text_android_release", "ui-text-android_release"})
public final class FontSpan
extends MetricAffectingSpan {
    @NotNull
    private final Function2<Integer, Boolean, Typeface> getTypeface;

    @VisibleForTesting
    public final void updatePaint$ui_text_android_release(@NotNull TextPaint textPaint) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        Typeface oldTypeface = textPaint.getTypeface();
        if (oldTypeface == null) {
            textPaint.setTypeface((Typeface)this.getTypeface.invoke((Object)400, (Object)false));
            return;
        }
        int weight = Build.VERSION.SDK_INT <= 28 ? (oldTypeface.isBold() ? 700 : 400) : oldTypeface.getWeight();
        textPaint.setTypeface((Typeface)this.getTypeface.invoke((Object)weight, (Object)oldTypeface.isItalic()));
    }

    public void updateDrawState(@NotNull TextPaint textPaint) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        this.updatePaint$ui_text_android_release(textPaint);
    }

    public void updateMeasureState(@NotNull TextPaint textPaint) {
        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
        this.updatePaint$ui_text_android_release(textPaint);
    }

    @NotNull
    public final Function2<Integer, Boolean, Typeface> getGetTypeface() {
        return this.getTypeface;
    }

    public FontSpan(@NotNull Function2<? super Integer, ? super Boolean, ? extends Typeface> getTypeface) {
        Intrinsics.checkNotNullParameter(getTypeface, (String)"getTypeface");
        this.getTypeface = getTypeface;
    }
}

