/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import android.graphics.Rect;
import android.view.View;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.layout.LayoutInfo;
import androidx.compose.ui.node.RootForTest;
import androidx.compose.ui.platform.ViewRootForTest;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.test.AndroidAssertions_androidKt;
import androidx.compose.ui.test.SelectionResult;
import androidx.compose.ui.test.SemanticsNodeInteraction;
import androidx.test.espresso.matcher.ViewMatchers;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u00a8\u0006\f"}, d2={"checkIsDisplayed", "", "Landroidx/compose/ui/test/SemanticsNodeInteraction;", "assertIsFullyVisible", "clippedNodeBoundsInWindow", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/ui/semantics/SemanticsNode;", "findClosestParentNode", "Landroidx/compose/ui/layout/LayoutInfo;", "selector", "Lkotlin/Function1;", "isInScreenBounds", "ui-test_release"})
public final class AndroidAssertions_androidKt {
    public static final boolean checkIsDisplayed(@NotNull SemanticsNodeInteraction $this$checkIsDisplayed, boolean assertIsFullyVisible) {
        SelectionResult nodes = SemanticsNodeInteraction.fetchSemanticsNodes$ui_test_release$default($this$checkIsDisplayed, true, null, 2, null);
        if (nodes.getSelectedNodes().isEmpty()) {
            return false;
        }
        if (nodes.getSelectedNodes().size() > 1) {
            throw new AssertionError((Object)("Failed to perform checkIsDisplayed check: Expected at most 1 node but found " + nodes.getSelectedNodes().size() + " nodes that satisfy (" + $this$checkIsDisplayed.getSelector$ui_test_release().getDescription() + ')'));
        }
        SemanticsNode node = (SemanticsNode)CollectionsKt.single(nodes.getSelectedNodes());
        LayoutInfo layoutInfo = node.getLayoutInfo();
        if (AndroidAssertions_androidKt.checkIsDisplayed$isNotPlaced(layoutInfo) || AndroidAssertions_androidKt.findClosestParentNode(layoutInfo, (Function1<? super LayoutInfo, Boolean>)((Function1)checkIsDisplayed.1.INSTANCE)) != null) {
            return false;
        }
        RootForTest rootForTest = node.getRoot();
        ViewRootForTest viewRootForTest = rootForTest instanceof ViewRootForTest ? (ViewRootForTest)rootForTest : null;
        if (viewRootForTest != null) {
            ViewRootForTest it = viewRootForTest;
            boolean bl = false;
            if (!ViewMatchers.isDisplayed().matches((Object)it.getView())) {
                return false;
            }
        }
        androidx.compose.ui.geometry.Rect globalRect = node.getBoundsInWindow();
        if (!AndroidAssertions_androidKt.isInScreenBounds(node, assertIsFullyVisible)) {
            return false;
        }
        return globalRect.getWidth() > 0.0f && globalRect.getHeight() > 0.0f;
    }

    @NotNull
    public static final androidx.compose.ui.geometry.Rect clippedNodeBoundsInWindow(@NotNull SemanticsNode $this$clippedNodeBoundsInWindow) {
        RootForTest rootForTest = $this$clippedNodeBoundsInWindow.getRoot();
        Intrinsics.checkNotNull((Object)rootForTest, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.ViewRootForTest");
        View composeView = ((ViewRootForTest)rootForTest).getView();
        int[] nArray = new int[]{0, 0};
        int[] it = nArray;
        boolean bl = false;
        composeView.getLocationInWindow(it);
        long rootLocationInWindow = OffsetKt.Offset((float)it[0], (float)it[1]);
        return $this$clippedNodeBoundsInWindow.getBoundsInRoot().translate-k-4lQ0M(rootLocationInWindow);
    }

    public static final boolean isInScreenBounds(@NotNull SemanticsNode $this$isInScreenBounds, boolean assertIsFullyVisible) {
        RootForTest rootForTest = $this$isInScreenBounds.getRoot();
        Intrinsics.checkNotNull((Object)rootForTest, (String)"null cannot be cast to non-null type androidx.compose.ui.platform.ViewRootForTest");
        View composeView = ((ViewRootForTest)rootForTest).getView();
        androidx.compose.ui.geometry.Rect nodeBoundsInWindow = AndroidAssertions_androidKt.clippedNodeBoundsInWindow($this$isInScreenBounds);
        if (nodeBoundsInWindow.getWidth() == 0.0f || nodeBoundsInWindow.getHeight() == 0.0f) {
            return false;
        }
        Rect globalRootRect = new Rect();
        if (!composeView.getGlobalVisibleRect(globalRootRect)) {
            return false;
        }
        if (assertIsFullyVisible) {
            return nodeBoundsInWindow.getTop() >= (float)globalRootRect.top && nodeBoundsInWindow.getLeft() >= (float)globalRootRect.left && nodeBoundsInWindow.getRight() <= (float)globalRootRect.right && nodeBoundsInWindow.getBottom() <= (float)globalRootRect.bottom;
        }
        return !nodeBoundsInWindow.intersect(new androidx.compose.ui.geometry.Rect((float)globalRootRect.left, (float)globalRootRect.top, (float)globalRootRect.right, (float)globalRootRect.bottom)).isEmpty();
    }

    private static final LayoutInfo findClosestParentNode(LayoutInfo $this$findClosestParentNode, Function1<? super LayoutInfo, Boolean> selector) {
        for (LayoutInfo currentParent = $this$findClosestParentNode.getParentInfo(); currentParent != null; currentParent = currentParent.getParentInfo()) {
            if (!((Boolean)selector.invoke((Object)currentParent)).booleanValue()) continue;
            return currentParent;
        }
        return null;
    }

    private static final boolean checkIsDisplayed$isNotPlaced(LayoutInfo node) {
        return !node.isPlaced();
    }

    public static final /* synthetic */ boolean access$checkIsDisplayed$isNotPlaced(LayoutInfo node) {
        return AndroidAssertions_androidKt.checkIsDisplayed$isNotPlaced(node);
    }
}

