/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import android.graphics.ColorSpace;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.Rgb;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0007J\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/graphics/ColorSpaceVerificationHelper;", "", "()V", "androidColorSpace", "Landroid/graphics/ColorSpace;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "composeColorSpace", "ui-graphics_release"})
@RequiresApi(value=26)
final class ColorSpaceVerificationHelper {
    @NotNull
    public static final ColorSpaceVerificationHelper INSTANCE = new ColorSpaceVerificationHelper();

    private ColorSpaceVerificationHelper() {
    }

    @JvmStatic
    @DoNotInline
    @RequiresApi(value=26)
    @NotNull
    public static final android.graphics.ColorSpace androidColorSpace(@NotNull ColorSpace $this$androidColorSpace) {
        android.graphics.ColorSpace colorSpace;
        ColorSpace colorSpace2 = $this$androidColorSpace;
        if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getSrgb())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getAces())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ACES);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getAcescg())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ACESCG);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getAdobeRgb())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.ADOBE_RGB);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getBt2020())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.BT2020);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getBt709())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.BT709);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getCieLab())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.CIE_LAB);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getCieXyz())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.CIE_XYZ);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getDciP3())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.DCI_P3);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getDisplayP3())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.DISPLAY_P3);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getExtendedSrgb())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.EXTENDED_SRGB);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getLinearExtendedSrgb())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_EXTENDED_SRGB);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getLinearSrgb())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_SRGB);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getNtsc1953())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.NTSC_1953);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getProPhotoRgb())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.PRO_PHOTO_RGB);
        } else if (Intrinsics.areEqual((Object)colorSpace2, (Object)ColorSpaces.INSTANCE.getSmpteC())) {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SMPTE_C);
        } else if ($this$androidColorSpace instanceof Rgb) {
            float[] whitePointArray = ((Rgb)$this$androidColorSpace).getWhitePoint().toXyz$ui_graphics_release();
            TransferParameters transferParams = ((Rgb)$this$androidColorSpace).getTransferParameters();
            ColorSpace.Rgb.TransferParameters androidTransferParams = transferParams != null ? new ColorSpace.Rgb.TransferParameters(transferParams.getA(), transferParams.getB(), transferParams.getC(), transferParams.getD(), transferParams.getE(), transferParams.getF(), transferParams.getGamma()) : null;
            colorSpace = (android.graphics.ColorSpace)(androidTransferParams != null ? new ColorSpace.Rgb($this$androidColorSpace.getName(), ((Rgb)$this$androidColorSpace).getPrimaries$ui_graphics_release(), whitePointArray, androidTransferParams) : new ColorSpace.Rgb($this$androidColorSpace.getName(), ((Rgb)$this$androidColorSpace).getPrimaries$ui_graphics_release(), whitePointArray, arg_0 -> ColorSpaceVerificationHelper.androidColorSpace$lambda$0(((Rgb)$this$androidColorSpace).getOetf(), arg_0), arg_0 -> ColorSpaceVerificationHelper.androidColorSpace$lambda$1(((Rgb)$this$androidColorSpace).getEotf(), arg_0), $this$androidColorSpace.getMinValue(0), $this$androidColorSpace.getMaxValue(0)));
        } else {
            colorSpace = android.graphics.ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
        }
        return colorSpace;
    }

    @JvmStatic
    @DoNotInline
    @RequiresApi(value=26)
    @NotNull
    public static final ColorSpace composeColorSpace(@NotNull android.graphics.ColorSpace $this$composeColorSpace) {
        ColorSpace colorSpace;
        int n = $this$composeColorSpace.getId();
        if (n == ColorSpace.Named.SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getSrgb();
        } else if (n == ColorSpace.Named.ACES.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getAces();
        } else if (n == ColorSpace.Named.ACESCG.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getAcescg();
        } else if (n == ColorSpace.Named.ADOBE_RGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getAdobeRgb();
        } else if (n == ColorSpace.Named.BT2020.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getBt2020();
        } else if (n == ColorSpace.Named.BT709.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getBt709();
        } else if (n == ColorSpace.Named.CIE_LAB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getCieLab();
        } else if (n == ColorSpace.Named.CIE_XYZ.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getCieXyz();
        } else if (n == ColorSpace.Named.DCI_P3.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getDciP3();
        } else if (n == ColorSpace.Named.DISPLAY_P3.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getDisplayP3();
        } else if (n == ColorSpace.Named.EXTENDED_SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getExtendedSrgb();
        } else if (n == ColorSpace.Named.LINEAR_EXTENDED_SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getLinearExtendedSrgb();
        } else if (n == ColorSpace.Named.LINEAR_SRGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getLinearSrgb();
        } else if (n == ColorSpace.Named.NTSC_1953.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getNtsc1953();
        } else if (n == ColorSpace.Named.PRO_PHOTO_RGB.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getProPhotoRgb();
        } else if (n == ColorSpace.Named.SMPTE_C.ordinal()) {
            colorSpace = ColorSpaces.INSTANCE.getSmpteC();
        } else {
            Rgb rgb;
            if ($this$composeColorSpace instanceof ColorSpace.Rgb) {
                ColorSpace.Rgb.TransferParameters transferParams = ((ColorSpace.Rgb)$this$composeColorSpace).getTransferParameters();
                WhitePoint whitePoint = ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint().length == 3 ? new WhitePoint(((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[0], ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[1], ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[2]) : new WhitePoint(((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[0], ((ColorSpace.Rgb)$this$composeColorSpace).getWhitePoint()[1]);
                TransferParameters composeTransferParams = transferParams != null ? new TransferParameters(transferParams.g, transferParams.a, transferParams.b, transferParams.c, transferParams.d, transferParams.e, transferParams.f) : null;
                rgb = new Rgb(((ColorSpace.Rgb)$this$composeColorSpace).getName(), ((ColorSpace.Rgb)$this$composeColorSpace).getPrimaries(), whitePoint, ((ColorSpace.Rgb)$this$composeColorSpace).getTransform(), arg_0 -> ColorSpaceVerificationHelper.composeColorSpace$lambda$2($this$composeColorSpace, arg_0), arg_0 -> ColorSpaceVerificationHelper.composeColorSpace$lambda$3($this$composeColorSpace, arg_0), $this$composeColorSpace.getMinValue(0), $this$composeColorSpace.getMaxValue(0), composeTransferParams, ((ColorSpace.Rgb)$this$composeColorSpace).getId());
            } else {
                rgb = ColorSpaces.INSTANCE.getSrgb();
            }
            colorSpace = rgb;
        }
        return colorSpace;
    }

    private static final double androidColorSpace$lambda$0(Function1 $tmp0, double p0) {
        return ((Number)$tmp0.invoke((Object)p0)).doubleValue();
    }

    private static final double androidColorSpace$lambda$1(Function1 $tmp0, double p0) {
        return ((Number)$tmp0.invoke((Object)p0)).doubleValue();
    }

    private static final double composeColorSpace$lambda$2(android.graphics.ColorSpace $this_composeColorSpace, double x) {
        return ((ColorSpace.Rgb)$this_composeColorSpace).getOetf().applyAsDouble(x);
    }

    private static final double composeColorSpace$lambda$3(android.graphics.ColorSpace $this_composeColorSpace, double x) {
        return ((ColorSpace.Rgb)$this_composeColorSpace).getEotf().applyAsDouble(x);
    }
}

