/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.material.lint.ColorsDetectorKt;
import androidx.compose.material.lint.ParameterWithArgument;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/material/lint/ColorsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UCallExpression;", "Companion", "material-lint"})
public final class ColorsDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ConflictingOnColor = Issue.Companion.create("ConflictingOnColor", "Background colors with the same value should have the same 'on' color", "In the Material color system background colors have a corresponding 'on' color which is used for the content color inside a component. For example, a button colored `primary` will have `onPrimary` text. Because of this, it is important that there is only one possible `onColor` for a given color value, otherwise there is no way to know which 'on' color should be used inside a component. To fix this either use the same 'on' color for identical background colors, or use a different background color for each 'on' color.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ColorsDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UCallExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            /*
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull UCallExpression node) {
                void $this$forEach$iv;
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv;
                Iterable $this$filterTo$iv$iv;
                void $this$mapIndexedTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) {
                    return;
                }
                PsiMethod method = psiMethod;
                if (!PsiUtilsKt.isInPackageName(method, Names.Material.INSTANCE.getPackageName())) {
                    return;
                }
                if (UastExpressionUtils.isConstructorCall((UElement)((UElement)node))) {
                    PsiClass psiClass = method.getContainingClass();
                    if (!Intrinsics.areEqual((Object)(psiClass == null ? null : psiClass.getName()), (Object)ColorsDetectorKt.access$getColors$p().getShortName())) {
                        return;
                    }
                } else if (node.getMethodName() != null && !Intrinsics.areEqual((Object)node.getMethodName(), (Object)ColorsDetectorKt.access$getLightColors$p().getShortName()) && !Intrinsics.areEqual((Object)node.getMethodName(), (Object)ColorsDetectorKt.access$getDarkColors$p().getShortName())) {
                    return;
                }
                PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"method.parameterList.parameters");
                Object[] $this$mapIndexed$iv = psiParameterArray;
                boolean $i$f$mapIndexed = false;
                Object[] objectArray = $this$mapIndexed$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>($this$mapIndexed$iv.length);
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void parameter;
                    void index;
                    int n = index$iv$iv;
                    index$iv$iv = n + 1;
                    PsiParameter psiParameter = (PsiParameter)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    UExpression argumentForParameter = node.getArgumentForParameter((int)index);
                    Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                    collection.add(new ParameterWithArgument((PsiParameter)parameter, argumentForParameter));
                }
                List parameters = (List)destination$iv$iv;
                Iterable $this$filter$iv = parameters;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Object destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ParameterWithArgument it = (ParameterWithArgument)element$iv$iv;
                    boolean bl = false;
                    if (!ColorsDetectorKt.access$getOnColorMap$p().keySet().contains(it.getParameter().getName())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    ParameterWithArgument it = (ParameterWithArgument)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSourceText() != null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$groupBy = false;
                $this$filterTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv2 = new LinkedHashMap<K, V>();
                boolean $i$f$groupByTo = false;
                for (T element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    ParameterWithArgument it = (ParameterWithArgument)element$iv$iv;
                    boolean bl = false;
                    String key$iv$iv = it.getSourceText();
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    boolean $i$f$getOrPut = false;
                    V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList<E>();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Collection<V> backgroundColorGroups = destination$iv$iv2.values();
                $this$groupBy$iv = backgroundColorGroups;
                JavaContext javaContext = this.$context;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void $this$groupByTo$iv$iv2;
                    void $this$groupBy$iv2;
                    Object e$iv2;
                    Iterable $this$distinctBy$iv;
                    void $this$mapTo$iv$iv;
                    List colors = (List)element$iv;
                    boolean bl = false;
                    Iterable $this$map$iv = colors;
                    boolean $i$f$map = false;
                    Iterable key$iv$iv = $this$map$iv;
                    Object destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        T element$iv22;
                        Collection collection;
                        block21: {
                            void parameter;
                            ParameterWithArgument parameterWithArgument = (ParameterWithArgument)item$iv$iv;
                            collection = destination$iv$iv3;
                            boolean bl3 = false;
                            String string = parameter.getParameter().getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameter.parameter.name");
                            String background = string;
                            String onColor = (String)ColorsDetectorKt.access$getOnColorMap$p().get(background);
                            Iterable $this$first$iv = parameters;
                            boolean $i$f$first = false;
                            for (T element$iv22 : $this$first$iv) {
                                ParameterWithArgument it = (ParameterWithArgument)element$iv22;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it.getParameter().getName(), (Object)onColor)) continue;
                                break block21;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        collection.add((ParameterWithArgument)element$iv22);
                    }
                    $this$map$iv = (List)destination$iv$iv3;
                    boolean $i$f$distinctBy = false;
                    HashSet<String> set$iv = new HashSet<String>();
                    ArrayList<T> list$iv = new ArrayList<T>();
                    for (Object e$iv2 : $this$distinctBy$iv) {
                        ParameterWithArgument it = (ParameterWithArgument)e$iv2;
                        boolean bl5 = false;
                        String key$iv = it.getParameter().getName();
                        if (!set$iv.add(key$iv)) continue;
                        list$iv.add(e$iv2);
                    }
                    $this$distinctBy$iv = list$iv;
                    boolean $i$f$groupBy2 = false;
                    set$iv = $this$groupBy$iv2;
                    destination$iv$iv3 = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo2 = false;
                    e$iv2 = $this$groupByTo$iv$iv2.iterator();
                    while (e$iv2.hasNext()) {
                        Object object;
                        E element$iv$iv = e$iv2.next();
                        ParameterWithArgument it = (ParameterWithArgument)element$iv$iv;
                        boolean bl6 = false;
                        String key$iv$iv2 = it.getSourceText();
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                        if (value$iv$iv$iv == null) {
                            boolean bl7 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    Object onColorGroups = destination$iv$iv3;
                    if (onColorGroups.size() <= 1) continue;
                    Iterable $this$forEach$iv2 = onColorGroups.values();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv3 : $this$forEach$iv2) {
                        List group = (List)element$iv3;
                        boolean bl8 = false;
                        Iterable $this$forEach$iv3 = group;
                        boolean $i$f$forEach3 = false;
                        for (T element$iv4 : $this$forEach$iv3) {
                            ParameterWithArgument parameter = (ParameterWithArgument)element$iv4;
                            boolean bl9 = false;
                            UExpression argument = parameter.getArgument();
                            if (argument == null) continue;
                            JavaContext.report$default((JavaContext)javaContext, (Issue)ColorsDetector.Companion.getConflictingOnColor(), (UElement)((UElement)argument), (Location)javaContext.getNameLocation((UElement)argument), (String)"Conflicting 'on' color for a given background", null, (int)16, null);
                        }
                    }
                }
            }
        };
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/compose/material/lint/ColorsDetector$Companion;", "", "()V", "ConflictingOnColor", "Lcom/android/tools/lint/detector/api/Issue;", "getConflictingOnColor", "()Lcom/android/tools/lint/detector/api/Issue;", "material-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getConflictingOnColor() {
            return ConflictingOnColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

