/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material.ripple;

import androidx.compose.foundation.IndicationInstance;
import androidx.compose.foundation.Interaction;
import androidx.compose.foundation.InteractionState;
import androidx.compose.material.ripple.ExperimentalRippleApi;
import androidx.compose.material.ripple.RippleAlpha;
import androidx.compose.material.ripple.RippleAnimation;
import androidx.compose.material.ripple.RippleAnimationKt;
import androidx.compose.material.ripple.StateLayer;
import androidx.compose.runtime.MutableStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalRippleApi
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0002J&\u0010\u001a\u001a\u00020\u0018*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0014\u0010!\u001a\u00020\u0018*\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0016J\u001e\u0010$\u001a\u00020\u0018*\u00020%2\u0006\u0010\u0006\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006("}, d2={"Landroidx/compose/material/ripple/RippleIndicationInstance;", "Landroidx/compose/foundation/IndicationInstance;", "bounded", "", "radius", "Landroidx/compose/ui/unit/Dp;", "color", "Landroidx/compose/runtime/State;", "Landroidx/compose/ui/graphics/Color;", "rippleAlpha", "Landroidx/compose/material/ripple/RippleAlpha;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(ZFLandroidx/compose/runtime/State;Landroidx/compose/material/ripple/RippleAlpha;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "currentPressPosition", "Landroidx/compose/ui/geometry/Offset;", "currentRipple", "Landroidx/compose/material/ripple/RippleAnimation;", "F", "ripples", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "stateLayer", "Landroidx/compose/material/ripple/StateLayer;", "onDispose", "", "removeRipple", "addRipple", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "targetRadius", "", "pressPosition", "addRipple-oBCulSU", "(Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;FJ)V", "drawIndication", "interactionState", "Landroidx/compose/foundation/InteractionState;", "drawRipples", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "drawRipples-1pI-_Hc", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;J)V", "material-ripple_release"})
final class RippleIndicationInstance
implements IndicationInstance {
    private final boolean bounded;
    private final float radius;
    @NotNull
    private final State<Color> color;
    @NotNull
    private final RippleAlpha rippleAlpha;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final StateLayer stateLayer;
    @NotNull
    private final SnapshotStateList<RippleAnimation> ripples;
    @Nullable
    private Offset currentPressPosition;
    @Nullable
    private RippleAnimation currentRipple;

    private RippleIndicationInstance(boolean bounded, float radius, State<Color> color, RippleAlpha rippleAlpha, CoroutineScope scope) {
        this.bounded = bounded;
        this.radius = radius;
        this.color = color;
        this.rippleAlpha = rippleAlpha;
        this.scope = scope;
        this.stateLayer = new StateLayer(this.bounded, this.rippleAlpha, this.scope);
        this.ripples = MutableStateKt.mutableStateListOf();
    }

    public void drawIndication(@NotNull ContentDrawScope $this$drawIndication, @NotNull InteractionState interactionState) {
        Intrinsics.checkNotNullParameter((Object)$this$drawIndication, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interactionState, (String)"interactionState");
        long color = ((Color)this.color.getValue()).unbox-impl();
        float $this$<get-isUnspecified>$iv22 = this.radius;
        boolean bl = false;
        float f = $this$<get-isUnspecified>$iv22;
        boolean bl2 = false;
        float targetRadius = Float.isNaN(f) ? RippleAnimationKt.getRippleEndRadius-4CXPiss((Density)$this$drawIndication, this.bounded, $this$drawIndication.getSize-NH-jbRc()) : $this$drawIndication.toPx-0680j_4(this.radius);
        $this$drawIndication.drawContent();
        StateLayer $this$<get-isUnspecified>$iv22 = this.stateLayer;
        boolean bl3 = false;
        boolean bl4 = false;
        StateLayer $this$drawIndication_u24lambda_u2d0 = $this$<get-isUnspecified>$iv22;
        boolean bl5 = false;
        $this$drawIndication_u24lambda_u2d0.drawStateLayer-pqS-j0w($this$drawIndication, interactionState, targetRadius, color);
        Offset pressPosition = interactionState.interactionPositionFor-_m7T9-E((Interaction)Interaction.Pressed.INSTANCE);
        if (pressPosition != null) {
            if (!Intrinsics.areEqual((Object)this.currentPressPosition, (Object)pressPosition)) {
                this.addRipple-oBCulSU($this$drawIndication, targetRadius, pressPosition.unbox-impl());
            }
        } else {
            this.removeRipple();
        }
        this.drawRipples-1pI-_Hc((DrawScope)$this$drawIndication, color);
    }

    /*
     * WARNING - void declaration
     */
    private final void addRipple-oBCulSU(ContentDrawScope $receiver, float targetRadius, long pressPosition) {
        void x$iv;
        RippleAnimation rippleAnimation = this.currentRipple;
        if (rippleAnimation != null) {
            rippleAnimation.finish();
        }
        long pxSize = SizeKt.Size((float)Size.getWidth-impl((long)$receiver.getSize-NH-jbRc()), (float)Size.getHeight-impl((long)$receiver.getSize-NH-jbRc()));
        float f = Size.getWidth-impl((long)$receiver.getSize-NH-jbRc()) / 2.0f;
        float y$iv = Size.getHeight-impl((long)$receiver.getSize-NH-jbRc()) / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var13_12 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var13_12);
        float f2 = y$iv;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long center = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        long position = this.bounded ? pressPosition : center;
        RippleAnimation ripple2 = new RippleAnimation(pxSize, position, targetRadius, this.scope, this.bounded, (Function1)new Function1<RippleAnimation, Unit>(this){
            final /* synthetic */ RippleIndicationInstance this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RippleAnimation ripple2) {
                Intrinsics.checkNotNullParameter((Object)ripple2, (String)"ripple");
                RippleIndicationInstance.access$getRipples$p(this.this$0).remove((Object)ripple2);
                if (Intrinsics.areEqual((Object)RippleIndicationInstance.access$getCurrentRipple$p(this.this$0), (Object)ripple2)) {
                    RippleIndicationInstance.access$setCurrentRipple$p(this.this$0, null);
                }
            }
        }, null);
        this.ripples.add((Object)ripple2);
        this.currentPressPosition = Offset.box-impl((long)pressPosition);
        this.currentRipple = ripple2;
    }

    private final void removeRipple() {
        RippleAnimation rippleAnimation = this.currentRipple;
        if (rippleAnimation != null) {
            rippleAnimation.finish();
        }
        this.currentRipple = null;
        this.currentPressPosition = null;
    }

    private final void drawRipples-1pI-_Hc(DrawScope $receiver, long color) {
        List $this$fastForEach$iv = (List)this.ripples;
        boolean $i$f$fastForEach = false;
        int n = 0;
        n = 0;
        int n2 = $this$fastForEach$iv.size() + -1;
        if (n <= n2) {
            do {
                int index$iv = n++;
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                RippleAnimation it = (RippleAnimation)item$iv;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                RippleAnimation $this$drawRipples_1pI__Hc_u24lambda_u2d2_u24lambda_u2d1 = it;
                boolean bl4 = false;
                float alpha = this.rippleAlpha.alphaForInteraction((Interaction)Interaction.Pressed.INSTANCE);
                if (alpha == 0.0f) continue;
                $this$drawRipples_1pI__Hc_u24lambda_u2d2_u24lambda_u2d1.draw-1pI-_Hc($receiver, Color.copy-0d7_KjU$default((long)color, (float)alpha, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null));
            } while (n <= n2);
        }
    }

    public void onDispose() {
        this.ripples.clear();
        this.currentRipple = null;
    }

    public /* synthetic */ RippleIndicationInstance(boolean bounded, float radius, State color, RippleAlpha rippleAlpha, CoroutineScope scope, DefaultConstructorMarker $constructor_marker) {
        this(bounded, radius, (State<Color>)color, rippleAlpha, scope);
    }

    public static final /* synthetic */ SnapshotStateList access$getRipples$p(RippleIndicationInstance $this) {
        return $this.ripples;
    }

    public static final /* synthetic */ RippleAnimation access$getCurrentRipple$p(RippleIndicationInstance $this) {
        return $this.currentRipple;
    }

    public static final /* synthetic */ void access$setCurrentRipple$p(RippleIndicationInstance $this, RippleAnimation rippleAnimation) {
        $this.currentRipple = rippleAnimation;
    }
}

