/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Payments: ImageVector
    get() {
        if (_payments != null) {
            return _payments!!
        }
        _payments = materialIcon(name = "Sharp.Payments") {
            materialPath {
                moveTo(23.0f, 7.0f)
                verticalLineToRelative(13.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(17.0f)
                verticalLineTo(7.0f)
                horizontalLineTo(23.0f)
                close()
                moveTo(19.0f, 16.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(18.0f)
                verticalLineTo(16.0f)
                close()
                moveTo(13.0f, 10.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveTo(13.0f, 11.66f, 13.0f, 10.0f)
                close()
            }
        }
        return _payments!!
    }

private var _payments: ImageVector? = null
