/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PersonSearch: ImageVector
    get() {
        if (_personSearch != null) {
            return _personSearch!!
        }
        _personSearch = materialIcon(name = "Rounded.PersonSearch") {
            materialPath {
                moveTo(10.0f, 8.0f)
                moveToRelative(-4.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, 8.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, -8.0f, 0.0f)
            }
            materialPath {
                moveTo(10.35f, 14.01f)
                curveTo(7.62f, 13.91f, 2.0f, 15.27f, 2.0f, 18.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(8.54f)
                curveTo(9.07f, 17.24f, 10.31f, 14.11f, 10.35f, 14.01f)
                close()
            }
            materialPath {
                moveTo(19.43f, 18.02f)
                curveToRelative(0.47f, -0.8f, 0.7f, -1.77f, 0.48f, -2.82f)
                curveToRelative(-0.34f, -1.64f, -1.72f, -2.95f, -3.38f, -3.16f)
                curveToRelative(-2.63f, -0.34f, -4.85f, 1.87f, -4.5f, 4.5f)
                curveToRelative(0.22f, 1.66f, 1.52f, 3.04f, 3.16f, 3.38f)
                curveToRelative(1.05f, 0.22f, 2.02f, -0.01f, 2.82f, -0.48f)
                lineToRelative(1.86f, 1.86f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(19.43f, 18.02f)
                close()
                moveTo(16.0f, 18.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(18.0f, 17.1f, 17.1f, 18.0f, 16.0f, 18.0f)
                close()
            }
        }
        return _personSearch!!
    }

private var _personSearch: ImageVector? = null
