/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Tty: ImageVector
    get() {
        if (_tty != null) {
            return _tty!!
        }
        _tty = materialIcon(name = "Outlined.Tty") {
            materialPath {
                moveTo(16.0f, 6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(18.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(19.0f, 4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(15.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(19.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(16.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(13.0f, 4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(20.0f, 15.82f)
                verticalLineToRelative(4.15f)
                curveToRelative(0.0f, 0.56f, -0.47f, 1.03f, -1.03f, 1.0f)
                curveToRelative(-2.89f, -0.17f, -5.6f, -1.03f, -7.97f, -2.4f)
                curveTo(8.27f, 16.99f, 6.01f, 14.73f, 4.43f, 12.0f)
                curveTo(3.05f, 9.63f, 2.2f, 6.92f, 2.03f, 4.03f)
                curveTo(2.0f, 3.47f, 2.47f, 3.0f, 3.03f, 3.0f)
                horizontalLineToRelative(4.15f)
                curveToRelative(0.48f, 0.0f, 0.89f, 0.34f, 0.98f, 0.8f)
                lineTo(8.9f, 7.48f)
                curveToRelative(0.07f, 0.33f, -0.04f, 0.67f, -0.27f, 0.9f)
                lineTo(6.1f, 10.9f)
                curveToRelative(1.43f, 2.5f, 3.5f, 4.57f, 6.0f, 6.0f)
                lineToRelative(2.52f, -2.52f)
                curveToRelative(0.24f, -0.24f, 0.58f, -0.34f, 0.9f, -0.27f)
                lineToRelative(3.67f, 0.73f)
                curveTo(19.66f, 14.93f, 20.0f, 15.34f, 20.0f, 15.82f)
                close()
                moveTo(5.18f, 8.99f)
                lineToRelative(1.65f, -1.65f)
                lineTo(6.36f, 5.0f)
                horizontalLineTo(4.13f)
                curveTo(4.3f, 6.37f, 4.66f, 7.71f, 5.18f, 8.99f)
                close()
                moveTo(18.0f, 16.64f)
                lineToRelative(-2.34f, -0.47f)
                lineToRelative(-1.65f, 1.65f)
                curveToRelative(1.28f, 0.52f, 2.63f, 0.87f, 3.99f, 1.05f)
                verticalLineTo(16.64f)
                close()
                moveTo(20.0f, 4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(20.0f, 12.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(12.0f)
                close()
                moveTo(13.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.0f)
                close()
            }
        }
        return _tty!!
    }

private var _tty: ImageVector? = null
