/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.EditOff: ImageVector
    get() {
        if (_editOff != null) {
            return _editOff!!
        }
        _editOff = materialIcon(name = "Outlined.EditOff") {
            materialPath {
                moveTo(14.06f, 9.02f)
                lineToRelative(0.92f, 0.92f)
                lineToRelative(-1.11f, 1.11f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(2.52f, -2.52f)
                lineToRelative(-3.75f, -3.75f)
                lineToRelative(-2.52f, 2.52f)
                lineToRelative(1.41f, 1.41f)
                lineTo(14.06f, 9.02f)
                close()
                moveTo(20.71f, 7.04f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-2.34f, -2.34f)
                curveTo(18.17f, 3.09f, 17.92f, 3.0f, 17.66f, 3.0f)
                reflectiveCurveToRelative(-0.51f, 0.1f, -0.7f, 0.29f)
                lineToRelative(-1.83f, 1.83f)
                lineToRelative(3.75f, 3.75f)
                lineTo(20.71f, 7.04f)
                close()
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(7.32f, 7.32f)
                lineTo(3.0f, 17.25f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(3.75f)
                lineToRelative(5.71f, -5.71f)
                lineToRelative(7.32f, 7.32f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(5.92f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-0.92f)
                lineToRelative(5.13f, -5.13f)
                lineToRelative(0.92f, 0.92f)
                lineTo(5.92f, 19.0f)
                close()
            }
        }
        return _editOff!!
    }

private var _editOff: ImageVector? = null
