/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MicExternalOff: ImageVector
    get() {
        if (_micExternalOff != null) {
            return _micExternalOff!!
        }
        _micExternalOff = materialIcon(name = "Filled.MicExternalOff") {
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(5.17f, 8.0f)
                lineTo(4.0f, 8.0f)
                lineToRelative(1.0f, 10.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                verticalLineToRelative(-1.17f)
                lineToRelative(5.78f, 5.78f)
                lineToRelative(1.41f, -1.42f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(0.56f, -5.61f)
                lineTo(12.0f, 14.83f)
                lineTo(12.0f, 18.0f)
                close()
                moveTo(14.0f, 6.0f)
                verticalLineToRelative(5.17f)
                lineToRelative(-2.0f, -2.0f)
                lineTo(12.0f, 6.0f)
                curveToRelative(0.0f, -2.21f, 1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                verticalLineToRelative(11.17f)
                lineToRelative(-2.0f, -2.0f)
                lineTo(18.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                close()
                moveTo(10.0f, 5.0f)
                curveToRelative(0.0f, 0.62f, -0.2f, 1.18f, -0.52f, 1.66f)
                lineTo(5.33f, 2.51f)
                curveTo(5.81f, 2.19f, 6.38f, 2.0f, 7.0f, 2.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, 1.34f, 3.0f, 3.0f)
                close()
            }
        }
        return _micExternalOff!!
    }

private var _micExternalOff: ImageVector? = null
