/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Light: ImageVector
    get() {
        if (_light != null) {
            return _light!!
        }
        _light = materialIcon(name = "Filled.Light") {
            materialPath {
                moveTo(13.0f, 6.06f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(3.06f)
                curveToRelative(-4.5f, 0.5f, -8.0f, 4.31f, -8.0f, 8.93f)
                curveTo(3.0f, 16.1f, 3.9f, 17.0f, 5.01f, 17.0f)
                horizontalLineTo(8.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                horizontalLineToRelative(2.99f)
                curveTo(20.1f, 17.0f, 21.0f, 16.1f, 21.0f, 14.99f)
                curveTo(21.0f, 10.37f, 17.5f, 6.56f, 13.0f, 6.06f)
                close()
                moveTo(12.0f, 15.0f)
                horizontalLineTo(5.0f)
                curveToRelative(0.0f, -3.86f, 3.14f, -7.0f, 7.0f, -7.0f)
                reflectiveCurveToRelative(7.0f, 3.14f, 7.0f, 7.0f)
                horizontalLineTo(12.0f)
                close()
            }
        }
        return _light!!
    }

private var _light: ImageVector? = null
