/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Landslide: ImageVector
    get() {
        if (_landslide != null) {
            return _landslide!!
        }
        _landslide = materialIcon(name = "TwoTone.Landslide") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(8.57f, 12.09f)
                lineToRelative(-1.57f, -2.09f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, 2.28f)
                lineToRelative(2.0f, 0.67f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.53f, 14.77f)
                lineToRelative(-2.58f, -1.03f)
                lineToRelative(-3.95f, 1.31f)
                lineToRelative(-2.0f, -0.66f)
                lineToRelative(0.0f, 1.89f)
                lineToRelative(2.0f, 0.67f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.0f, 4.65f)
                lineToRelative(0.0f, -2.01f)
                lineToRelative(-2.58f, -0.52f)
                lineToRelative(-1.42f, 0.95f)
                lineToRelative(0.0f, 1.86f)
                lineToRelative(1.23f, 0.82f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.0f, 19.05f)
                lineToRelative(-2.0f, -0.66f)
                lineToRelative(0.0f, 1.61f)
                lineToRelative(14.0f, 0.0f)
                lineToRelative(-2.97f, -3.96f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.0f, 9.96f)
                lineToRelative(0.0f, 1.08f)
                lineToRelative(0.8f, 0.64f)
                lineToRelative(2.2f, -0.98f)
                lineToRelative(0.0f, -1.1f)
                lineToRelative(-2.0f, -0.44f)
                close()
            }
            materialPath {
                moveTo(11.0f, 12.0f)
                lineTo(8.0f, 8.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(20.0f)
                lineToRelative(-6.0f, -8.0f)
                lineTo(11.0f, 12.0f)
                close()
                moveTo(4.0f, 10.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(1.57f, 2.09f)
                lineTo(6.0f, 12.95f)
                lineToRelative(-2.0f, -0.67f)
                verticalLineTo(10.0f)
                close()
                moveTo(4.0f, 14.39f)
                lineToRelative(2.0f, 0.67f)
                lineToRelative(3.95f, -1.32f)
                lineToRelative(2.58f, 1.03f)
                lineTo(6.0f, 16.95f)
                lineToRelative(-2.0f, -0.67f)
                verticalLineTo(14.39f)
                close()
                moveTo(4.0f, 20.0f)
                verticalLineToRelative(-1.61f)
                lineToRelative(2.0f, 0.67f)
                lineToRelative(9.03f, -3.01f)
                lineTo(18.0f, 20.0f)
                horizontalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 6.0f)
                verticalLineTo(1.0f)
                lineToRelative(-5.0f, -1.0f)
                lineTo(9.0f, 2.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(3.0f, 2.0f)
                lineTo(17.0f, 6.0f)
                close()
                moveTo(11.0f, 3.07f)
                lineToRelative(1.42f, -0.95f)
                lineTo(15.0f, 2.64f)
                verticalLineToRelative(2.01f)
                lineToRelative(-2.77f, 1.11f)
                lineTo(11.0f, 4.93f)
                verticalLineTo(3.07f)
                close()
            }
            materialPath {
                moveTo(18.5f, 7.0f)
                lineTo(16.0f, 9.0f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.5f, 2.0f)
                lineToRelative(4.5f, -2.0f)
                verticalLineTo(8.0f)
                lineTo(18.5f, 7.0f)
                close()
                moveTo(21.0f, 10.7f)
                lineToRelative(-2.2f, 0.98f)
                lineTo(18.0f, 11.04f)
                verticalLineTo(9.96f)
                lineToRelative(1.0f, -0.8f)
                lineToRelative(2.0f, 0.44f)
                verticalLineTo(10.7f)
                close()
            }
        }
        return _landslide!!
    }

private var _landslide: ImageVector? = null
