/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Park: ImageVector
    get() {
        if (_park != null) {
            return _park!!
        }
        _park = materialIcon(name = "Rounded.Park") {
            materialPath {
                moveTo(16.96f, 12.0f)
                horizontalLineToRelative(0.08f)
                curveToRelative(0.81f, 0.0f, 1.28f, -0.91f, 0.82f, -1.57f)
                lineToRelative(-5.08f, -7.25f)
                curveToRelative(-0.4f, -0.57f, -1.24f, -0.57f, -1.64f, 0.0f)
                lineTo(6.1f, 10.43f)
                curveTo(5.64f, 11.09f, 6.12f, 12.0f, 6.93f, 12.0f)
                horizontalLineToRelative(0.04f)
                lineToRelative(-2.9f, 4.46f)
                curveTo(3.63f, 17.12f, 4.11f, 18.0f, 4.91f, 18.0f)
                horizontalLineToRelative(5.08f)
                verticalLineToRelative(2.02f)
                curveToRelative(0.0f, 1.09f, 0.89f, 1.98f, 1.98f, 1.98f)
                horizontalLineToRelative(0.0f)
                curveToRelative(1.09f, 0.0f, 1.98f, -0.89f, 1.98f, -1.98f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(5.15f)
                curveToRelative(0.8f, 0.0f, 1.28f, -0.89f, 0.83f, -1.55f)
                lineTo(16.96f, 12.0f)
                close()
            }
        }
        return _park!!
    }

private var _park: ImageVector? = null
