/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.EmojiTransportation: ImageVector
    get() {
        if (_emojiTransportation != null) {
            return _emojiTransportation!!
        }
        _emojiTransportation = materialIcon(name = "Rounded.EmojiTransportation") {
            materialPath {
                moveTo(21.99f, 14.77f)
                lineToRelative(-1.43f, -4.11f)
                curveToRelative(-0.14f, -0.4f, -0.52f, -0.66f, -0.97f, -0.66f)
                horizontalLineTo(12.4f)
                curveToRelative(-0.46f, 0.0f, -0.83f, 0.26f, -0.98f, 0.66f)
                lineTo(10.0f, 14.77f)
                verticalLineToRelative(5.24f)
                curveToRelative(0.0f, 0.55f, 0.45f, 0.99f, 1.0f, 0.99f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(0.99f, -0.44f, 1.0f, -0.99f)
                lineTo(21.99f, 14.77f)
                close()
                moveTo(11.61f, 13.34f)
                lineToRelative(0.69f, -2.0f)
                curveToRelative(0.05f, -0.2f, 0.24f, -0.34f, 0.46f, -0.34f)
                horizontalLineToRelative(6.48f)
                curveToRelative(0.21f, 0.0f, 0.4f, 0.14f, 0.47f, 0.34f)
                lineToRelative(0.69f, 2.0f)
                curveToRelative(0.11f, 0.32f, -0.13f, 0.66f, -0.47f, 0.66f)
                horizontalLineToRelative(-7.85f)
                curveTo(11.74f, 14.0f, 11.5f, 13.66f, 11.61f, 13.34f)
                close()
                moveTo(11.99f, 17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(12.54f, 17.0f, 11.99f, 17.0f)
                close()
                moveTo(19.99f, 17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(20.54f, 17.0f, 19.99f, 17.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 4.5f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(8.0f)
                curveTo(7.45f, 3.0f, 7.0f, 3.45f, 7.0f, 4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(3.0f)
                curveTo(2.45f, 8.0f, 2.0f, 8.45f, 2.0f, 9.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(9.5f)
                curveTo(3.0f, 9.22f, 3.22f, 9.0f, 3.5f, 9.0f)
                horizontalLineToRelative(4.0f)
                curveTo(7.78f, 9.0f, 8.0f, 8.78f, 8.0f, 8.5f)
                verticalLineToRelative(-4.0f)
                curveTo(8.0f, 4.22f, 8.22f, 4.0f, 8.5f, 4.0f)
                horizontalLineToRelative(5.0f)
                curveTo(13.78f, 4.0f, 14.0f, 4.22f, 14.0f, 4.5f)
                close()
            }
            materialPath {
                moveTo(5.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 15.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
        }
        return _emojiTransportation!!
    }

private var _emojiTransportation: ImageVector? = null
