/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SmartButton: ImageVector
    get() {
        if (_smartButton != null) {
            return _smartButton!!
        }
        _smartButton = materialIcon(name = "Outlined.SmartButton") {
            materialPath {
                moveTo(22.0f, 9.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineToRelative(-1.0f)
                lineToRelative(0.0f, -2.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(16.0f)
                curveTo(21.1f, 7.0f, 22.0f, 7.9f, 22.0f, 9.0f)
                close()
                moveTo(14.5f, 19.0f)
                lineToRelative(1.09f, -2.41f)
                lineTo(18.0f, 15.5f)
                lineToRelative(-2.41f, -1.09f)
                lineTo(14.5f, 12.0f)
                lineToRelative(-1.09f, 2.41f)
                lineTo(11.0f, 15.5f)
                lineToRelative(2.41f, 1.09f)
                lineTo(14.5f, 19.0f)
                close()
                moveTo(17.0f, 14.0f)
                lineToRelative(0.62f, -1.38f)
                lineTo(19.0f, 12.0f)
                lineToRelative(-1.38f, -0.62f)
                lineTo(17.0f, 10.0f)
                lineToRelative(-0.62f, 1.38f)
                lineTo(15.0f, 12.0f)
                lineToRelative(1.38f, 0.62f)
                lineTo(17.0f, 14.0f)
                close()
                moveTo(14.5f, 19.0f)
                lineToRelative(1.09f, -2.41f)
                lineTo(18.0f, 15.5f)
                lineToRelative(-2.41f, -1.09f)
                lineTo(14.5f, 12.0f)
                lineToRelative(-1.09f, 2.41f)
                lineTo(11.0f, 15.5f)
                lineToRelative(2.41f, 1.09f)
                lineTo(14.5f, 19.0f)
                close()
                moveTo(17.0f, 14.0f)
                lineToRelative(0.62f, -1.38f)
                lineTo(19.0f, 12.0f)
                lineToRelative(-1.38f, -0.62f)
                lineTo(17.0f, 10.0f)
                lineToRelative(-0.62f, 1.38f)
                lineTo(15.0f, 12.0f)
                lineToRelative(1.38f, 0.62f)
                lineTo(17.0f, 14.0f)
                close()
            }
        }
        return _smartButton!!
    }

private var _smartButton: ImageVector? = null
