/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Plagiarism: ImageVector
    get() {
        if (_plagiarism != null) {
            return _plagiarism!!
        }
        _plagiarism = materialIcon(name = "Filled.Plagiarism") {
            materialPath {
                moveTo(14.0f, 2.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 2.0f, 4.0f, 2.9f, 4.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 1.99f, 2.0f)
                horizontalLineTo(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(8.0f)
                lineTo(14.0f, 2.0f)
                close()
                moveTo(15.04f, 19.45f)
                lineToRelative(-1.88f, -1.88f)
                curveToRelative(-1.33f, 0.71f, -3.01f, 0.53f, -4.13f, -0.59f)
                curveToRelative(-1.37f, -1.37f, -1.37f, -3.58f, 0.0f, -4.95f)
                curveToRelative(1.37f, -1.37f, 3.58f, -1.37f, 4.95f, 0.0f)
                curveToRelative(1.12f, 1.12f, 1.31f, 2.8f, 0.59f, 4.13f)
                lineToRelative(1.88f, 1.88f)
                lineTo(15.04f, 19.45f)
                close()
                moveTo(13.0f, 9.0f)
                verticalLineTo(3.5f)
                lineTo(18.5f, 9.0f)
                horizontalLineTo(13.0f)
                close()
            }
            materialPath {
                moveTo(11.5f, 14.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
        }
        return _plagiarism!!
    }

private var _plagiarism: ImageVector? = null
