/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MarkAsUnread: ImageVector
    get() {
        if (_markAsUnread != null) {
            return _markAsUnread!!
        }
        _markAsUnread = materialIcon(name = "Filled.MarkAsUnread") {
            materialPath {
                moveTo(18.83f, 7.0f)
                horizontalLineToRelative(-2.6f)
                lineTo(10.5f, 4.0f)
                lineTo(4.0f, 7.4f)
                lineTo(4.0f, 17.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                lineTo(2.0f, 7.17f)
                curveToRelative(0.0f, -0.53f, 0.32f, -1.09f, 0.8f, -1.34f)
                lineTo(10.5f, 2.0f)
                lineToRelative(7.54f, 3.83f)
                curveToRelative(0.43f, 0.23f, 0.73f, 0.7f, 0.79f, 1.17f)
                close()
                moveTo(20.0f, 8.0f)
                lineTo(7.0f, 8.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-9.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(20.0f, 11.67f)
                lineTo(13.5f, 15.0f)
                lineTo(7.0f, 11.67f)
                lineTo(7.0f, 10.0f)
                lineToRelative(6.5f, 3.33f)
                lineTo(20.0f, 10.0f)
                verticalLineToRelative(1.67f)
                close()
            }
        }
        return _markAsUnread!!
    }

private var _markAsUnread: ImageVector? = null
