/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CompassCalibration: ImageVector
    get() {
        if (_compassCalibration != null) {
            return _compassCalibration!!
        }
        _compassCalibration = materialIcon(name = "Filled.CompassCalibration") {
            materialPath {
                moveTo(12.0f, 17.0f)
                moveToRelative(-4.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, 8.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, -8.0f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 10.07f)
                curveToRelative(1.95f, 0.0f, 3.72f, 0.79f, 5.0f, 2.07f)
                lineToRelative(5.0f, -5.0f)
                curveTo(19.44f, 4.59f, 15.9f, 3.0f, 12.0f, 3.0f)
                reflectiveCurveTo(4.56f, 4.59f, 2.0f, 7.15f)
                lineToRelative(5.0f, 5.0f)
                curveToRelative(1.28f, -1.28f, 3.05f, -2.08f, 5.0f, -2.08f)
                close()
            }
        }
        return _compassCalibration!!
    }

private var _compassCalibration: ImageVector? = null
