/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BrowserUpdated: ImageVector
    get() {
        if (_browserUpdated != null) {
            return _browserUpdated!!
        }
        _browserUpdated = materialIcon(name = "Sharp.BrowserUpdated") {
            materialPath {
                moveTo(22.0f, 13.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-5.0f)
                lineToRelative(1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-2.0f)
                lineToRelative(1.0f, -1.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(3.0f)
                lineToRelative(10.0f, 0.0f)
                verticalLineToRelative(2.0f)
                lineTo(4.0f, 5.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(22.0f)
                close()
                moveTo(15.0f, 15.0f)
                lineToRelative(-5.0f, -5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(4.0f)
                lineTo(15.0f, 15.0f)
                close()
            }
        }
        return _browserUpdated!!
    }

private var _browserUpdated: ImageVector? = null
