/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.DoNotStep: ImageVector
    get() {
        if (_doNotStep != null) {
            return _doNotStep!!
        }
        _doNotStep = materialIcon(name = "Outlined.DoNotStep") {
            materialPath {
                moveTo(18.51f, 15.68f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(4.48f, -4.48f)
                lineTo(23.0f, 11.2f)
                lineTo(18.51f, 15.68f)
                close()
                moveTo(14.98f, 12.15f)
                moveTo(14.98f, 12.15f)
                lineToRelative(3.07f, -3.07f)
                lineTo(13.8f, 4.82f)
                lineToRelative(-3.08f, 3.07f)
                lineTo(9.3f, 6.47f)
                lineTo(13.8f, 2.0f)
                lineToRelative(0.0f, 0.0f)
                lineToRelative(7.08f, 7.08f)
                lineToRelative(-4.48f, 4.48f)
                lineTo(14.98f, 12.15f)
                close()
                moveTo(21.18f, 21.2f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-5.94f, -5.94f)
                lineTo(10.5f, 20.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(-2.63f)
                curveToRelative(0.0f, -0.84f, 0.52f, -1.57f, 1.3f, -1.88f)
                curveToRelative(0.58f, -0.23f, 1.28f, -0.56f, 1.97f, -1.02f)
                lineToRelative(1.38f, 1.38f)
                curveTo(5.74f, 15.95f, 5.87f, 16.0f, 6.0f, 16.0f)
                reflectiveCurveToRelative(0.26f, -0.05f, 0.36f, -0.15f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(-1.28f, -1.28f)
                curveToRelative(0.27f, -0.24f, 0.53f, -0.51f, 0.77f, -0.8f)
                lineToRelative(1.27f, 1.27f)
                curveToRelative(0.09f, 0.1f, 0.23f, 0.15f, 0.35f, 0.15f)
                reflectiveCurveToRelative(0.25f, -0.05f, 0.35f, -0.15f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(-1.4f, -1.4f)
                curveToRelative(0.19f, -0.34f, 0.34f, -0.72f, 0.45f, -1.12f)
                lineToRelative(1.71f, 1.72f)
                curveToRelative(0.09f, 0.1f, 0.23f, 0.15f, 0.35f, 0.15f)
                reflectiveCurveToRelative(0.25f, -0.05f, 0.35f, -0.15f)
                curveToRelative(0.19f, -0.2f, 0.19f, -0.5f, 0.01f, -0.7f)
                lineToRelative(-7.9f, -7.9f)
                lineToRelative(1.42f, -1.41f)
                lineTo(21.18f, 21.2f)
                close()
                moveTo(12.42f, 15.26f)
                lineToRelative(-1.67f, -1.68f)
                lineTo(7.42f, 16.9f)
                curveToRelative(-0.78f, 0.78f, -2.05f, 0.78f, -2.83f, -0.01f)
                lineTo(4.4f, 16.72f)
                lineToRelative(-0.47f, 0.24f)
                curveToRelative(-0.29f, 0.14f, -0.59f, 0.27f, -0.89f, 0.39f)
                lineTo(3.03f, 18.0f)
                horizontalLineToRelative(6.64f)
                lineTo(12.42f, 15.26f)
                close()
            }
        }
        return _doNotStep!!
    }

private var _doNotStep: ImageVector? = null
