/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Sharp.BrandingWatermark: ImageVector
    get() {
        if (_brandingWatermark != null) {
            return _brandingWatermark!!
        }
        _brandingWatermark = materialIcon(name = "AutoMirrored.Sharp.BrandingWatermark", autoMirror
                = true) {
            materialPath {
                moveTo(23.0f, 3.0f)
                lineTo(1.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(22.0f)
                lineTo(23.0f, 3.0f)
                close()
                moveTo(21.0f, 19.0f)
                horizontalLineToRelative(-9.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(6.0f)
                close()
            }
        }
        return _brandingWatermark!!
    }

private var _brandingWatermark: ImageVector? = null
