/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Rounded._360: ImageVector
    get() {
        if (__360 != null) {
            return __360!!
        }
        __360 = materialIcon(name = "AutoMirrored.Rounded._360", autoMirror = true) {
            materialPath {
                moveTo(12.0f, 7.0f)
                curveTo(6.48f, 7.0f, 2.0f, 9.24f, 2.0f, 12.0f)
                curveToRelative(0.0f, 2.24f, 2.94f, 4.13f, 7.0f, 4.77f)
                verticalLineToRelative(2.02f)
                curveToRelative(0.0f, 0.45f, 0.54f, 0.67f, 0.85f, 0.35f)
                lineToRelative(2.79f, -2.79f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(-2.79f, -2.79f)
                curveToRelative(-0.31f, -0.31f, -0.85f, -0.09f, -0.85f, 0.36f)
                verticalLineToRelative(1.52f)
                curveToRelative(-3.15f, -0.56f, -5.0f, -1.9f, -5.0f, -2.73f)
                curveToRelative(0.0f, -1.06f, 3.04f, -3.0f, 8.0f, -3.0f)
                reflectiveCurveToRelative(8.0f, 1.94f, 8.0f, 3.0f)
                curveToRelative(0.0f, 0.66f, -1.2f, 1.68f, -3.32f, 2.34f)
                curveToRelative(-0.41f, 0.13f, -0.68f, 0.51f, -0.68f, 0.94f)
                curveToRelative(0.0f, 0.67f, 0.65f, 1.16f, 1.28f, 0.96f)
                curveTo(20.11f, 15.36f, 22.0f, 13.79f, 22.0f, 12.0f)
                curveToRelative(0.0f, -2.76f, -4.48f, -5.0f, -10.0f, -5.0f)
                close()
            }
        }
        return __360!!
    }

private var __360: ImageVector? = null
