/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.RampRight: ImageVector
    get() {
        if (_rampRight != null) {
            return _rampRight!!
        }
        _rampRight = materialIcon(name = "TwoTone.RampRight") {
            materialPath {
                moveTo(11.0f, 21.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.83f)
                lineToRelative(1.59f, 1.59f)
                lineTo(16.0f, 7.0f)
                lineToRelative(-4.0f, -4.0f)
                lineTo(8.0f, 7.0f)
                lineToRelative(1.41f, 1.41f)
                lineTo(11.0f, 6.83f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, 4.27f, -4.03f, 7.13f, -6.0f, 8.27f)
                lineToRelative(1.46f, 1.46f)
                curveTo(8.37f, 17.56f, 9.9f, 16.19f, 11.0f, 14.7f)
                lineTo(11.0f, 21.0f)
                close()
            }
        }
        return _rampRight!!
    }

private var _rampRight: ImageVector? = null
