/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TurnLeft: ImageVector
    get() {
        if (_turnLeft != null) {
            return _turnLeft!!
        }
        _turnLeft = materialIcon(name = "Sharp.TurnLeft") {
            materialPath {
                moveTo(6.83f, 11.0f)
                lineToRelative(1.58f, 1.59f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-1.58f, 1.59f)
                lineToRelative(10.17f, 0.0f)
                lineToRelative(0.0f, 11.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -9.0f)
                close()
            }
        }
        return _turnLeft!!
    }

private var _turnLeft: ImageVector? = null
