/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FlipCameraIos: ImageVector
    get() {
        if (_flipCameraIos != null) {
            return _flipCameraIos!!
        }
        _flipCameraIos = materialIcon(name = "Rounded.FlipCameraIos") {
            materialPath {
                moveTo(20.0f, 5.0f)
                horizontalLineToRelative(-3.17f)
                lineToRelative(-1.24f, -1.35f)
                curveTo(15.22f, 3.24f, 14.68f, 3.0f, 14.12f, 3.0f)
                horizontalLineTo(9.88f)
                curveToRelative(-0.56f, 0.0f, -1.1f, 0.24f, -1.48f, 0.65f)
                lineTo(7.17f, 5.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 5.0f, 2.0f, 5.9f, 2.0f, 7.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(7.0f)
                curveTo(22.0f, 5.9f, 21.1f, 5.0f, 20.0f, 5.0f)
                close()
                moveTo(13.67f, 17.7f)
                curveTo(13.15f, 17.89f, 12.59f, 18.0f, 12.0f, 18.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                horizontalLineTo(5.0f)
                lineToRelative(2.5f, -2.5f)
                lineTo(10.0f, 13.0f)
                horizontalLineTo(8.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                curveToRelative(0.46f, 0.0f, 0.91f, -0.08f, 1.32f, -0.23f)
                curveToRelative(0.19f, -0.07f, 0.39f, -0.03f, 0.53f, 0.11f)
                curveTo(14.11f, 17.14f, 14.01f, 17.57f, 13.67f, 17.7f)
                close()
                moveTo(16.5f, 15.5f)
                lineTo(14.0f, 13.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                curveToRelative(-0.46f, 0.0f, -0.91f, 0.08f, -1.32f, 0.23f)
                curveToRelative(-0.19f, 0.07f, -0.39f, 0.03f, -0.53f, -0.11f)
                curveTo(9.89f, 8.86f, 9.99f, 8.43f, 10.33f, 8.3f)
                curveTo(10.85f, 8.11f, 11.41f, 8.0f, 12.0f, 8.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                lineTo(16.5f, 15.5f)
                close()
            }
        }
        return _flipCameraIos!!
    }

private var _flipCameraIos: ImageVector? = null
